/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification.config;

import java.util.Properties;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManagerImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class NotificationGmailConfig {
    private final SpringdogSettingManagerImpl settingManager;

    public NotificationGmailConfig(SpringdogSettingManagerImpl settingManager) {
        this.settingManager = settingManager;
    }

    @Bean(name={"gmailNotificationSender"})
    public JavaMailSender gmailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost("smtp.gmail.com");
        mailSender.setPort(587);
        NotificationGlobalSetting notificationSetting = this.settingManager.getSettings().getNotificationGlobalSetting();
        mailSender.setUsername(notificationSetting.getUsername());
        mailSender.setPassword(notificationSetting.getPassword());
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.timeout", "5000");
        return mailSender;
    }
}

