/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification.email;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.easypeelsecurity.springdog.notification.Notification;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManagerImpl;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

abstract class AbstractEmailNotification<K, V>
implements Notification {
    private JavaMailSender mailSender;
    private SpringdogSettingManagerImpl settingManager;
    protected Cause<K, V> cause;
    protected Cause<K, V> recovered;

    AbstractEmailNotification(JavaMailSender mailSender, SpringdogSettingManagerImpl settingManager) {
        this.mailSender = mailSender;
        this.settingManager = settingManager;
    }

    AbstractEmailNotification() {
    }

    @Override
    public final boolean send() {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        NotificationGlobalSetting notificationSetting = this.settingManager.getSettings().getNotificationGlobalSetting();
        if (!notificationSetting.isEnabled()) {
            return false;
        }
        try {
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "UTF-8");
            mimeMessageHelper.setTo(notificationSetting.getRecipient());
            mimeMessageHelper.setSubject("[springdog] %s".formatted(this.getSubject()));
            mimeMessageHelper.setText(this.getContent(), true);
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getContent() {
        return "<html>\n  <head>\n    <style>\n      body { font-family: Arial, sans-serif; margin: 20px; }\n      .header { background-color: #f2f2f2; padding: 10px;\n       border-radius: 5px; text-align: center; }\n      .content { margin-top: 20px; line-height: 1.6;}\n      .alert { color: #d9534f; font-weight: bold; }\n      .footer { margin-top: 30px; font-size: 12px; color: #888888;\n       border-top: 1px solid #ddd; padding-top: 10px; }\n    </style>\n  </head>\n  <body>\n    <h1>Notification</h1>\n      %s\n    <div class='footer'>\n      <p>If you have any questions, please contact our github issue.</p>\n      <p>Thank you,<br>The springdog team</p>\n    </div>\n  </body>\n</html>\n".formatted(this.generateBody());
    }

    public void setCause(K key, V value) {
        this.cause = new Cause<K, V>(key, value);
        this.recovered = null;
    }

    public void setRecovery(K key, V value) {
        this.recovered = new Cause<K, V>(key, value);
        this.cause = null;
    }

    protected abstract String generateBody();

    protected record Cause<K, V>(K key, V value) {
    }
}

