/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification.email;

import org.easypeelsecurity.springdog.notification.email.AbstractEmailNotification;
import org.easypeelsecurity.springdog.notification.email.state.MetricState;
import org.easypeelsecurity.springdog.notification.email.state.NormalState;

public class MetricContext<K, V extends Comparable<V>> {
    private MetricState<V> state;
    private final AbstractEmailNotification<K, V> emailNotification;

    public MetricContext(String metricName, AbstractEmailNotification<K, V> emailNotification) {
        this.state = new NormalState<V>(metricName, this);
        this.emailNotification = emailNotification;
    }

    public void setState(MetricState<V> state) {
        this.state = state;
    }

    public void checkMetric(V currentValue, V threshold) {
        this.state.checkThreshold(currentValue, threshold);
    }

    public void sendWarningNotification(K metricName, V value) {
        this.emailNotification.setCause(metricName, value);
        this.emailNotification.send();
    }

    public void sendResolvedNotification(K metricName, V value) {
        this.emailNotification.setRecovery(metricName, value);
        this.emailNotification.send();
    }
}

