/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification.email;

import java.util.HashMap;
import org.easypeelsecurity.springdog.notification.email.AbstractEmailNotification;
import org.easypeelsecurity.springdog.shared.settings.SlowResponsePlaceholder;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManagerImpl;
import org.easypeelsecurity.springdog.shared.settings.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class SlowResponseEmailNotification
extends AbstractEmailNotification<String, Long> {
    private final SpringdogSettingManagerImpl settingManager;

    @Autowired
    public SlowResponseEmailNotification(@Qualifier(value="gmailNotificationSender") JavaMailSender mailSender, SpringdogSettingManagerImpl settingManager) {
        super(mailSender, settingManager);
        this.settingManager = settingManager;
    }

    @Override
    protected String generateBody() {
        HashMap<SlowResponsePlaceholder, String> replacement = new HashMap<SlowResponsePlaceholder, String>();
        replacement.put(SlowResponsePlaceholder.ENDPOINT_PATH, (String)this.cause.key());
        replacement.put(SlowResponsePlaceholder.RESPONSE_MS, ((Long)this.cause.value()).toString());
        return this.settingManager.getSettings().getNotificationGlobalSetting().generateMailTemplate(Template.SLOW_RESPONSE_BODY, replacement);
    }

    @Override
    public String getSubject() {
        HashMap<SlowResponsePlaceholder, String> replacement = new HashMap<SlowResponsePlaceholder, String>();
        replacement.put(SlowResponsePlaceholder.ENDPOINT_PATH, (String)this.cause.key());
        replacement.put(SlowResponsePlaceholder.RESPONSE_MS, ((Long)this.cause.value()).toString());
        return this.settingManager.getSettings().getNotificationGlobalSetting().generateMailTemplate(Template.SLOW_RESPONSE_SUBJECT, replacement);
    }
}

