/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.notification.email;

import java.util.HashMap;
import org.easypeelsecurity.springdog.notification.email.AbstractEmailNotification;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManagerImpl;
import org.easypeelsecurity.springdog.shared.settings.SystemWatchPlaceholder;
import org.easypeelsecurity.springdog.shared.settings.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class SystemWatchEmailNotification
extends AbstractEmailNotification<String, Double> {
    private SpringdogSettingManagerImpl settingManager;

    @Autowired
    public SystemWatchEmailNotification(@Qualifier(value="gmailNotificationSender") JavaMailSender mailSender, SpringdogSettingManagerImpl settingManager) {
        super(mailSender, settingManager);
        this.settingManager = settingManager;
    }

    SystemWatchEmailNotification() {
    }

    @Override
    protected String generateBody() {
        HashMap<SystemWatchPlaceholder, String> replacement = new HashMap<SystemWatchPlaceholder, String>();
        replacement.put(SystemWatchPlaceholder.TARGET_DEVICE, (String)this.cause.key());
        if (this.cause != null) {
            replacement.put(SystemWatchPlaceholder.TARGET_STATUS, "overused");
        } else {
            replacement.put(SystemWatchPlaceholder.TARGET_STATUS, "recovered");
        }
        replacement.put(SystemWatchPlaceholder.USAGE_PERCENT, ((Double)this.cause.value()).toString());
        return this.settingManager.getSettings().getNotificationGlobalSetting().generateMailTemplate(Template.SYSTEM_WATCH_BODY, replacement);
    }

    @Override
    public String getSubject() {
        HashMap<SystemWatchPlaceholder, String> replacement = new HashMap<SystemWatchPlaceholder, String>();
        replacement.put(SystemWatchPlaceholder.TARGET_DEVICE, (String)this.cause.key());
        if (this.cause != null) {
            replacement.put(SystemWatchPlaceholder.TARGET_STATUS, "overused");
        } else {
            replacement.put(SystemWatchPlaceholder.TARGET_STATUS, "recovered");
        }
        replacement.put(SystemWatchPlaceholder.USAGE_PERCENT, ((Double)this.cause.value()).toString());
        return this.settingManager.getSettings().getNotificationGlobalSetting().generateMailTemplate(Template.SYSTEM_WATCH_SUBJECT, replacement);
    }
}

