/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.configuration;

import jakarta.annotation.PostConstruct;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogAgentProperties;
import org.easypeelsecurity.springdog.shared.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="springdog")
@EnableConfigurationProperties(value={SpringdogAgentProperties.class})
public class SpringdogProperties {
    private final Logger logger = LoggerFactory.getLogger(SpringdogProperties.class);
    private final SpringdogAgentProperties agentProperties;

    public SpringdogProperties(SpringdogAgentProperties agentProperties) {
        this.agentProperties = agentProperties;
    }

    @PostConstruct
    public void init() {
        this.logger.info("SpringdogProperties was loaded");
        this.logger.debug("Springdog Agent's base path was set by {}", (Object)this.agentProperties.getBasePath());
        this.logger.debug("Springdog Agent's username was set by {}", (Object)this.agentProperties.getUsername());
        this.logger.debug("Springdog Agent's password was set by {}", (Object)this.agentProperties.getPassword());
        this.logger.debug("Springdog Agent's external access was set by {}", (Object)this.agentProperties.isExternalAccess());
    }

    public String getAgentBasePath() {
        return this.agentProperties.getBasePath();
    }

    public String computeAbsolutePath(String extraPath) {
        Assert.notNull(extraPath, "extraPath must not be null");
        if (extraPath.isEmpty()) {
            extraPath = "/";
        }
        if (this.getAgentBasePath().startsWith("/")) {
            return this.getAgentBasePath() + extraPath;
        }
        return "/" + this.getAgentBasePath() + extraPath;
    }

    public String getAgentUsername() {
        return this.agentProperties.getUsername();
    }

    public String getAgentPassword() {
        return this.agentProperties.getPassword();
    }

    public boolean enableExternalAccess() {
        return this.agentProperties.isExternalAccess();
    }
}

