/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.dto;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.easypeelsecurity.springdog.shared.dto.EndpointHeaderDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointParameterDto;
import org.easypeelsecurity.springdog.shared.enums.HttpMethod;
import org.easypeelsecurity.springdog.shared.enums.RuleStatus;
import org.easypeelsecurity.springdog.shared.util.Assert;

public class EndpointDto {
    private final Set<EndpointParameterDto> parameters = new HashSet<EndpointParameterDto>();
    private final Set<EndpointHeaderDto> headers = new HashSet<EndpointHeaderDto>();
    private long id;
    private String path;
    private String methodSignature;
    private HttpMethod httpMethod;
    private Set<String> parameterNamesToEnable = new HashSet<String>();
    private Set<String> headerNamesToEnable = new HashSet<String>();
    private boolean isPatternPath;
    private RuleStatus ruleStatus;
    private boolean ruleIpBased;
    private boolean rulePermanentBan;
    private int ruleRequestLimitCount;
    private int ruleTimeLimitInSeconds;
    private int ruleBanTimeInSeconds;

    public EndpointDto(long id, String path, String methodSignature, HttpMethod httpMethod, Set<EndpointParameterDto> parameters, Set<EndpointHeaderDto> headers, boolean isPatternPath, RuleStatus ruleStatus, boolean ruleIpBased, boolean rulePermanentBan, int ruleRequestLimitCount, int ruleTimeLimitInSeconds, int ruleBanTimeInSeconds) {
        Assert.hasText(path, "Endpoint must not be null or empty");
        Assert.hasText(methodSignature, "Method signature must not be null or empty");
        Assert.notNull((Object)httpMethod, "HttpMethod must not be null");
        this.id = id;
        this.path = path;
        this.methodSignature = methodSignature;
        this.httpMethod = httpMethod;
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.addAll(parameters);
        }
        if (headers != null && !headers.isEmpty()) {
            this.headers.addAll(headers);
        }
        this.isPatternPath = isPatternPath;
        this.ruleStatus = ruleStatus;
        this.ruleIpBased = ruleIpBased;
        this.rulePermanentBan = rulePermanentBan;
        this.ruleRequestLimitCount = ruleRequestLimitCount;
        this.ruleTimeLimitInSeconds = ruleTimeLimitInSeconds;
        this.ruleBanTimeInSeconds = ruleBanTimeInSeconds;
    }

    public EndpointDto(String path, String methodSignature, HttpMethod httpMethod, boolean isPatternPath) {
        this.path = path;
        this.methodSignature = methodSignature;
        this.httpMethod = httpMethod;
        this.isPatternPath = isPatternPath;
    }

    public int timeLimitDays() {
        return this.ruleTimeLimitInSeconds / 86400;
    }

    public int timeLimitHours() {
        int remainSeconds = this.ruleTimeLimitInSeconds % 86400;
        return remainSeconds / 3600;
    }

    public int timeLimitMinutes() {
        int remainSeconds = this.ruleTimeLimitInSeconds % 86400;
        return (remainSeconds %= 3600) / 60;
    }

    public int timeLimitSeconds() {
        return this.ruleTimeLimitInSeconds % 60;
    }

    public int banTimeDays() {
        return this.ruleBanTimeInSeconds / 86400;
    }

    public int banTimeHours() {
        int remainSeconds = this.ruleBanTimeInSeconds % 86400;
        return remainSeconds / 3600;
    }

    public int banTimeMinutes() {
        int remainSeconds = this.ruleBanTimeInSeconds % 86400;
        return (remainSeconds %= 3600) / 60;
    }

    public int banTimeSeconds() {
        int remainSeconds = this.ruleBanTimeInSeconds % 86400;
        return (remainSeconds %= 3600) % 60;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointDto)) {
            return false;
        }
        EndpointDto that = (EndpointDto)o;
        return this.path.equals(that.path) && this.methodSignature.equals(that.methodSignature) && this.httpMethod == that.httpMethod && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.methodSignature.hashCode();
        result = 31 * result + this.httpMethod.hashCode();
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.headers);
        return result;
    }

    public String getFqmn() {
        Assert.isTrue(this.methodSignature.contains(".") && this.methodSignature.contains("("), "May not be a valid method signature");
        int firstSpaceIndex = this.methodSignature.indexOf(" ");
        return this.methodSignature.substring(firstSpaceIndex + 1);
    }

    public String getFqcn() {
        Assert.isTrue(this.methodSignature.contains(".") && this.methodSignature.contains("("), "May not be a valid method signature");
        String fqmn = this.getFqmn();
        String onlyMethod = fqmn.substring(0, fqmn.indexOf("("));
        return onlyMethod.substring(0, onlyMethod.lastIndexOf("."));
    }

    public String getMethodName() {
        String fqmn = this.getFqmn();
        String fqcn = this.getFqcn();
        return fqmn.replace(fqcn, "").substring(1);
    }

    public void addParameters(Set<EndpointParameterDto> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.addAll(parameters);
        }
    }

    public void addHeaders(Set<EndpointHeaderDto> headers) {
        if (headers != null && !headers.isEmpty()) {
            this.headers.addAll(headers);
        }
    }

    @Generated
    public static EndpointDtoBuilder builder() {
        return new EndpointDtoBuilder();
    }

    @Generated
    public Set<EndpointParameterDto> getParameters() {
        return this.parameters;
    }

    @Generated
    public Set<EndpointHeaderDto> getHeaders() {
        return this.headers;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public Set<String> getParameterNamesToEnable() {
        return this.parameterNamesToEnable;
    }

    @Generated
    public Set<String> getHeaderNamesToEnable() {
        return this.headerNamesToEnable;
    }

    @Generated
    public boolean isPatternPath() {
        return this.isPatternPath;
    }

    @Generated
    public RuleStatus getRuleStatus() {
        return this.ruleStatus;
    }

    @Generated
    public boolean isRuleIpBased() {
        return this.ruleIpBased;
    }

    @Generated
    public boolean isRulePermanentBan() {
        return this.rulePermanentBan;
    }

    @Generated
    public int getRuleRequestLimitCount() {
        return this.ruleRequestLimitCount;
    }

    @Generated
    public int getRuleTimeLimitInSeconds() {
        return this.ruleTimeLimitInSeconds;
    }

    @Generated
    public int getRuleBanTimeInSeconds() {
        return this.ruleBanTimeInSeconds;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    @Generated
    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Generated
    public void setParameterNamesToEnable(Set<String> parameterNamesToEnable) {
        this.parameterNamesToEnable = parameterNamesToEnable;
    }

    @Generated
    public void setHeaderNamesToEnable(Set<String> headerNamesToEnable) {
        this.headerNamesToEnable = headerNamesToEnable;
    }

    @Generated
    public void setPatternPath(boolean isPatternPath) {
        this.isPatternPath = isPatternPath;
    }

    @Generated
    public void setRuleStatus(RuleStatus ruleStatus) {
        this.ruleStatus = ruleStatus;
    }

    @Generated
    public void setRuleIpBased(boolean ruleIpBased) {
        this.ruleIpBased = ruleIpBased;
    }

    @Generated
    public void setRulePermanentBan(boolean rulePermanentBan) {
        this.rulePermanentBan = rulePermanentBan;
    }

    @Generated
    public void setRuleRequestLimitCount(int ruleRequestLimitCount) {
        this.ruleRequestLimitCount = ruleRequestLimitCount;
    }

    @Generated
    public void setRuleTimeLimitInSeconds(int ruleTimeLimitInSeconds) {
        this.ruleTimeLimitInSeconds = ruleTimeLimitInSeconds;
    }

    @Generated
    public void setRuleBanTimeInSeconds(int ruleBanTimeInSeconds) {
        this.ruleBanTimeInSeconds = ruleBanTimeInSeconds;
    }

    @Generated
    public EndpointDto() {
    }

    @Generated
    public static class EndpointDtoBuilder {
        @Generated
        private long id;
        @Generated
        private String path;
        @Generated
        private String methodSignature;
        @Generated
        private HttpMethod httpMethod;
        @Generated
        private Set<EndpointParameterDto> parameters;
        @Generated
        private Set<EndpointHeaderDto> headers;
        @Generated
        private boolean isPatternPath;
        @Generated
        private RuleStatus ruleStatus;
        @Generated
        private boolean ruleIpBased;
        @Generated
        private boolean rulePermanentBan;
        @Generated
        private int ruleRequestLimitCount;
        @Generated
        private int ruleTimeLimitInSeconds;
        @Generated
        private int ruleBanTimeInSeconds;

        @Generated
        EndpointDtoBuilder() {
        }

        @Generated
        public EndpointDtoBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public EndpointDtoBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public EndpointDtoBuilder methodSignature(String methodSignature) {
            this.methodSignature = methodSignature;
            return this;
        }

        @Generated
        public EndpointDtoBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Generated
        public EndpointDtoBuilder parameters(Set<EndpointParameterDto> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public EndpointDtoBuilder headers(Set<EndpointHeaderDto> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public EndpointDtoBuilder isPatternPath(boolean isPatternPath) {
            this.isPatternPath = isPatternPath;
            return this;
        }

        @Generated
        public EndpointDtoBuilder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Generated
        public EndpointDtoBuilder ruleIpBased(boolean ruleIpBased) {
            this.ruleIpBased = ruleIpBased;
            return this;
        }

        @Generated
        public EndpointDtoBuilder rulePermanentBan(boolean rulePermanentBan) {
            this.rulePermanentBan = rulePermanentBan;
            return this;
        }

        @Generated
        public EndpointDtoBuilder ruleRequestLimitCount(int ruleRequestLimitCount) {
            this.ruleRequestLimitCount = ruleRequestLimitCount;
            return this;
        }

        @Generated
        public EndpointDtoBuilder ruleTimeLimitInSeconds(int ruleTimeLimitInSeconds) {
            this.ruleTimeLimitInSeconds = ruleTimeLimitInSeconds;
            return this;
        }

        @Generated
        public EndpointDtoBuilder ruleBanTimeInSeconds(int ruleBanTimeInSeconds) {
            this.ruleBanTimeInSeconds = ruleBanTimeInSeconds;
            return this;
        }

        @Generated
        public EndpointDto build() {
            return new EndpointDto(this.id, this.path, this.methodSignature, this.httpMethod, this.parameters, this.headers, this.isPatternPath, this.ruleStatus, this.ruleIpBased, this.rulePermanentBan, this.ruleRequestLimitCount, this.ruleTimeLimitInSeconds, this.ruleBanTimeInSeconds);
        }

        @Generated
        public String toString() {
            return "EndpointDto.EndpointDtoBuilder(id=" + this.id + ", path=" + this.path + ", methodSignature=" + this.methodSignature + ", httpMethod=" + String.valueOf((Object)this.httpMethod) + ", parameters=" + String.valueOf(this.parameters) + ", headers=" + String.valueOf(this.headers) + ", isPatternPath=" + this.isPatternPath + ", ruleStatus=" + String.valueOf((Object)this.ruleStatus) + ", ruleIpBased=" + this.ruleIpBased + ", rulePermanentBan=" + this.rulePermanentBan + ", ruleRequestLimitCount=" + this.ruleRequestLimitCount + ", ruleTimeLimitInSeconds=" + this.ruleTimeLimitInSeconds + ", ruleBanTimeInSeconds=" + this.ruleBanTimeInSeconds + ")";
        }
    }
}

