/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.settings;

import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.easypeelsecurity.springdog.shared.settings.Placeholder;
import org.easypeelsecurity.springdog.shared.settings.Template;
import org.springframework.util.StringUtils;

public class NotificationGlobalSetting {
    private static final String EMAIL_REGEX = "^(?=.{1,64}@)[A-Za-z0-9_\\-]+(\\.[A-Za-z0-9_\\-]+)*@[^-][A-Za-z0-9\\-]+(\\.[A-Za-z0-9\\-]+)*(\\.[A-Za-z]{2,})$";
    private boolean enabled;
    private String recipient;
    private String username;
    private String password;
    private Map<Template, String> templates = new EnumMap<Template, String>(Template.class);

    protected NotificationGlobalSetting() {
        this.initializeDefaultTemplates();
    }

    protected NotificationGlobalSetting(boolean enabled, String recipient, String username, String password) {
        this.enabled = enabled;
        this.recipient = recipient;
        this.username = username;
        this.password = password;
        this.initializeDefaultTemplates();
    }

    public boolean canSendNotification() {
        return this.enabled && StringUtils.hasText((String)this.recipient) && StringUtils.hasText((String)this.username) && StringUtils.hasText((String)this.password);
    }

    public String getTemplate(Template templateType) {
        return this.templates.get((Object)templateType);
    }

    public String generateMailTemplate(Template templateType, Map<Placeholder, String> replacements) {
        String template = this.templates.get((Object)templateType);
        if (template == null) {
            throw new IllegalArgumentException("Template with key '" + String.valueOf((Object)templateType) + "' does not exist.");
        }
        String result = template;
        for (Map.Entry<Placeholder, String> entry : replacements.entrySet()) {
            String placeholder = entry.getKey().getPlaceholderName();
            result = result.replace(placeholder, entry.getValue());
        }
        return result;
    }

    private void initializeDefaultTemplates() {
        for (Template template : Template.values()) {
            this.templates.put(template, template.getDefaultTemplate());
        }
    }

    protected void validate() {
        if (this.enabled) {
            if (this.recipient == null || !this.recipient.matches(EMAIL_REGEX)) {
                throw new IllegalArgumentException("Recipient must be a valid email address. ^(?=.{1,64}@)[A-Za-z0-9_\\-]+(\\.[A-Za-z0-9_\\-]+)*@[^-][A-Za-z0-9\\-]+(\\.[A-Za-z0-9\\-]+)*(\\.[A-Za-z]{2,})$");
            }
            if (this.username == null || this.username.isEmpty()) {
                throw new IllegalArgumentException("Username must not be null or empty");
            }
            if (this.password == null || this.password.isEmpty()) {
                throw new IllegalArgumentException("Password must not be null or empty");
            }
            this.templates.values().forEach(template -> {
                if (template == null || template.isEmpty()) {
                    throw new IllegalArgumentException("Templates must not be null or empty");
                }
            });
        }
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Map<Template, String> getTemplates() {
        return this.templates;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setTemplates(Map<Template, String> templates) {
        this.templates = templates;
    }
}

