/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.settings;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.easypeelsecurity.springdog.shared.settings.NotificationGlobalSetting;
import org.easypeelsecurity.springdog.shared.settings.SlowResponseSetting;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettingManager;
import org.easypeelsecurity.springdog.shared.settings.SpringdogSettings;
import org.easypeelsecurity.springdog.shared.settings.SystemWatchSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpringdogSettingManagerImpl
implements SpringdogSettingManager {
    private static final Logger logger = LoggerFactory.getLogger(SpringdogSettingManagerImpl.class);
    private static final String SPRINGDOG_SETTING_FILE = "springdog-settings.json";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private SpringdogSettings settings;
    private final File settingsFile;

    @Autowired
    public SpringdogSettingManagerImpl() {
        this(new File(SPRINGDOG_SETTING_FILE));
    }

    public SpringdogSettingManagerImpl(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    @Override
    public SpringdogSettings getSettings() {
        this.rwLock.readLock().lock();
        try {
            if (this.settings == null) {
                this.rwLock.readLock().unlock();
                this.rwLock.writeLock().lock();
                try {
                    if (this.settings == null) {
                        this.settings = this.loadOrCreateSettings();
                    }
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                this.rwLock.readLock().lock();
            }
            SpringdogSettings springdogSettings = this.settings;
            return springdogSettings;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void updateSettings(SpringdogSettings newSettings) {
        this.rwLock.writeLock().lock();
        try {
            this.settings = newSettings;
            this.saveSettings();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save springdog settings.", e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void updateSystemWatchSetting(SystemWatchSetting newSetting) {
        this.rwLock.writeLock().lock();
        try {
            SpringdogSettings existSetting = this.getSettings();
            existSetting.changeSystemWatchSetting(newSetting);
            this.updateSettings(existSetting);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void updateNotificationGlobalSetting(NotificationGlobalSetting newSetting) {
        this.rwLock.writeLock().lock();
        try {
            SpringdogSettings existSetting = this.getSettings();
            existSetting.changeNotificationGlobalSetting(newSetting);
            this.updateSettings(existSetting);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void updateSlowResponseSetting(SlowResponseSetting newSetting) {
        this.rwLock.writeLock().lock();
        try {
            SpringdogSettings existSetting = this.getSettings();
            existSetting.changeSlowResponseSetting(newSetting);
            this.updateSettings(existSetting);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private SpringdogSettings loadOrCreateSettings() {
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            if (!this.settingsFile.exists()) {
                SpringdogSettings defaultSetting = new SpringdogSettings();
                this.objectMapper.writeValue(this.settingsFile, (Object)defaultSetting);
                return defaultSetting;
            }
            return (SpringdogSettings)this.objectMapper.readValue(this.settingsFile, SpringdogSettings.class);
        }
        catch (UnrecognizedPropertyException e) {
            logger.warn("Unknown property detected. Overwriting configuration with default settings.", (Throwable)e);
            SpringdogSettings defaultSetting = new SpringdogSettings();
            try {
                this.objectMapper.writeValue(this.settingsFile, (Object)defaultSetting);
            }
            catch (IOException ioException) {
                logger.error("Failed to write default settings.", (Throwable)ioException);
            }
            return defaultSetting;
        }
        catch (IOException e) {
            logger.error("Failed to load springdog settings.", (Throwable)e);
            return new SpringdogSettings();
        }
    }

    private void saveSettings() throws IOException {
        this.objectMapper.writeValue(this.settingsFile, (Object)this.settings);
    }
}

