/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.util;

public abstract class Assert {
    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text, String message) {
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String text, String message) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Iterable<?> iterable, String message) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String text, String message, Object ... args) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(Iterable<?> iterable, String message, Object ... args) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notEmpty(Object[] array, String message, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void notNull(Object object, String message, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void hasText(String text, String message, Object ... args) {
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isTrue(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isNotEqual(Object object1, Object object2, String message) {
        if (object1.equals(object2)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEqual(Object object1, Object object2, String message) {
        if (!object1.equals(object2)) {
            throw new IllegalArgumentException(message);
        }
    }
}

