/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class IpAddressUtil {
    private static final String[] HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static String getClientIp(HttpServletRequest request) {
        return Stream.of(HEADERS_TO_TRY).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).findFirst().orElse(request.getRemoteAddr());
    }

    public static boolean isLocal(String ip) {
        return ip.startsWith("127.") || ip.startsWith("0:0:0:0:0:0:0:1") || ip.startsWith("::1");
    }
}

