/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.util;

import java.lang.reflect.Parameter;
import org.springframework.web.method.HandlerMethod;

public abstract class MethodSignatureParser {
    public static String parse(HandlerMethod method) {
        String returnType = method.getMethod().getReturnType().getName();
        String fullClassName = method.getBeanType().getName();
        StringBuilder result = new StringBuilder(returnType + " " + fullClassName + "." + method.getMethod().getName() + "(");
        StringBuilder parameterPart = new StringBuilder();
        for (Parameter parameter : method.getMethod().getParameters()) {
            parameterPart.append(parameter.getType().getName()).append(", ");
        }
        if (!parameterPart.isEmpty()) {
            result.append((CharSequence)parameterPart);
            result = new StringBuilder(result.substring(0, result.length() - 2));
        }
        result.append(")");
        return String.valueOf(result);
    }
}

