/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.shared.util;

import org.easypeelsecurity.springdog.shared.util.Assert;

public abstract class TimeUtil {
    private static final int SECONDS_IN_DAY = 86400;
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_MINUTE = 60;

    public static int convertToSeconds(int days, int hours, int minutes, int seconds) {
        Assert.isTrue(days >= 0, "Days must be greater than or equal to 0");
        Assert.isTrue(hours >= 0, "Hours must be greater than or equal to 0");
        Assert.isTrue(minutes >= 0, "Minutes must be greater than or equal to 0");
        return days * 86400 + hours * 3600 + minutes * 60 + seconds;
    }

    public static Time convertToSeconds(int seconds) {
        Assert.isTrue(seconds >= 0, "Seconds must be greater than or equal to 0");
        int days = seconds / 86400;
        int hours = (seconds -= days * 86400) / 3600;
        int minutes = (seconds -= hours * 3600) / 60;
        return new Time(days, hours, minutes, seconds -= minutes * 60);
    }

    private record Time(int days, int hours, int minutes, int seconds) {
    }
}

