/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.storage.config;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class SpringdogDatasourceConfig {
    Logger logger = LoggerFactory.getLogger(SpringdogDatasourceConfig.class);

    @Bean(name={"springdogRepository"})
    public ServerRuntime springdogRepository() {
        this.logger.info("Springdog datasource configuration started");
        return ServerRuntime.builder().jdbcDriver("org.apache.derby.jdbc.EmbeddedDriver").url("jdbc:derby:springdog-embedded-database;create=true").addConfig("springdog-db/cayenne-before-migration/cayenne-springdog.xml").build();
    }

    @Bean(name={"springdogContext"})
    @Scope(value="prototype")
    public ObjectContext springdogContext() {
        return this.springdogRepository().newContext();
    }

    @Bean(name={"springdogFlyway"})
    public Flyway flyway() {
        this.logger.info("Springdog datasource flyway migration ready");
        FluentConfiguration config = new FluentConfiguration();
        config.dataSource("jdbc:derby:springdog-embedded-database", null, null).baselineOnMigrate(true).baselineVersion("0").sqlMigrationPrefix("V").sqlMigrationSeparator("__").locations(new String[]{"classpath:springdog-db/migration"}).validateMigrationNaming(true);
        return new Flyway((org.flywaydb.core.api.configuration.Configuration)config);
    }

    @Bean(name={"springdogFlywayRunner"})
    public CommandLineRunner migrateFlyway(@Qualifier(value="springdogFlyway") Flyway flyway, @Qualifier(value="springdogRepository") ServerRuntime springdogRepository) {
        return args -> {
            this.logger.info("Starting Flyway migration for Springdog datasource");
            flyway.migrate();
            this.logger.info("Flyway migration for Springdog datasource completed");
        };
    }
}

