/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.storage.repository;

import java.time.LocalDate;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.statistics.EndpointMetricRepository;
import org.easypeelsecurity.springdog.domain.statistics.model.EndpointMetric;
import org.easypeelsecurity.springdog.shared.vo.DashboardResponse;
import org.springframework.stereotype.Repository;

@Repository
public class EndpointMetricRepositoryImpl
implements EndpointMetricRepository {
    public EndpointMetric findByEndpointAndMetricDateOrNull(ObjectContext context, Endpoint endpoint, LocalDate specificDate) {
        return (EndpointMetric)ObjectSelect.query(EndpointMetric.class).where(EndpointMetric.ENDPOINT.eq((Object)endpoint).andExp(EndpointMetric.METRIC_DATE.eq((Object)specificDate))).selectOne(context);
    }

    public List<EndpointMetric> getRecentEndpointMetrics(ObjectContext context, long endpointId, int limit) {
        return ObjectSelect.query(EndpointMetric.class).where(EndpointMetric.ENDPOINT.eqId((Object)endpointId)).orderBy(new Ordering[]{EndpointMetric.METRIC_DATE.desc()}).limit(limit).select(context);
    }

    public List<DashboardResponse.DailyEndpointMetric> getDailyEndpointMetrics(ObjectContext context, int limitDays) {
        EJBQLQuery query = new EJBQLQuery("SELECT SUM(em.pageView), AVG(em.averageResponseMs), SUM(em.failureWithRatelimit), em.metricDate\nFROM EndpointMetric em\nGROUP BY em.metricDate\nORDER BY em.metricDate DESC\n");
        query.setFetchLimit(limitDays);
        List results = context.performQuery((Query)query);
        return results.stream().map(row -> new DashboardResponse.DailyEndpointMetric(((Number)row[0]).longValue(), ((Number)row[1]).longValue(), ((Number)row[2]).longValue(), (LocalDate)row[3])).toList();
    }

    public List<DashboardResponse.DailyTopTrafficEndpoint> getDailyTopTrafficEndpoints(ObjectContext context, int limitDays, LocalDate specificDate) {
        return ObjectSelect.query(EndpointMetric.class).where(EndpointMetric.METRIC_DATE.eq((Object)specificDate)).orderBy(new Ordering[]{EndpointMetric.METRIC_DATE.desc()}).orderBy(new Ordering[]{EndpointMetric.PAGE_VIEW.desc()}).limit(limitDays).select(context).stream().map(metric -> new DashboardResponse.DailyTopTrafficEndpoint(metric.getEndpoint().getPath(), metric.getEndpoint().getHttpMethod(), metric.getPageView())).toList();
    }

    public List<DashboardResponse.DailySlowestEndpoint> getDailySlowestEndpoints(ObjectContext context, int limitDays, LocalDate specificDate) {
        return ObjectSelect.query(EndpointMetric.class).where(EndpointMetric.METRIC_DATE.eq((Object)specificDate)).orderBy(new Ordering[]{EndpointMetric.METRIC_DATE.desc()}).orderBy(new Ordering[]{EndpointMetric.AVERAGE_RESPONSE_MS.desc()}).limit(limitDays).select(context).stream().map(metric -> new DashboardResponse.DailySlowestEndpoint(metric.getEndpoint().getPath(), metric.getEndpoint().getHttpMethod(), metric.getPageView())).toList();
    }

    public List<DashboardResponse.DailyTopFailWithRatelimitEndpoint> getDailyTopFailWithRatelimitEndpoints(ObjectContext context, int limitDays, LocalDate specificDate) {
        return ObjectSelect.query(EndpointMetric.class).where(EndpointMetric.METRIC_DATE.eq((Object)specificDate)).orderBy(new Ordering[]{EndpointMetric.METRIC_DATE.desc()}).orderBy(new Ordering[]{EndpointMetric.FAILURE_WITH_RATELIMIT.desc()}).limit(limitDays).select(context).stream().map(metric -> new DashboardResponse.DailyTopFailWithRatelimitEndpoint(metric.getEndpoint().getPath(), metric.getEndpoint().getHttpMethod(), metric.getPageView())).toList();
    }
}

