/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.storage.repository;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionCause;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionClass;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingRepository;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionType;
import org.springframework.stereotype.Repository;

@Repository
public class ExceptionListRepositoryImpl
implements ExceptionListingRepository {
    public List<ExceptionType> findAllExceptions(ObjectContext context) {
        return ObjectSelect.query(ExceptionType.class).orderBy(new Ordering[]{ExceptionType.PACKAGE_TYPE.asc()}).prefetch(ExceptionType.EXCEPTION_CLASSES.joint()).select(context);
    }

    public ExceptionClass findExceptionClassByIdOrNull(ObjectContext context, long exceptionClassId) {
        return (ExceptionClass)ObjectSelect.query(ExceptionClass.class).where(ExceptionClass.ID.eq((Object)exceptionClassId)).selectOne(context);
    }

    public ExceptionClass findByExceptionClassByFQCM(ObjectContext context, String exceptionFQCM) {
        return (ExceptionClass)ObjectSelect.query(ExceptionClass.class).where(ExceptionClass.EXCEPTION_CLASS_NAME.eq((Object)exceptionFQCM)).selectOne(context);
    }

    public List<ExceptionCause> findAllParentExceptionCauses(ObjectContext context) {
        String ejbql = "SELECT e FROM ExceptionCause e\nWHERE e.id NOT IN (SELECT e2.nextException.id FROM ExceptionCause e2 WHERE e2.nextException IS NOT NULL)\nORDER BY e.timestamp DESC\n";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        return context.performQuery((Query)query);
    }

    public ExceptionCause findExceptionCauseByIdOrNull(ObjectContext context, long exceptionCauseId) {
        return (ExceptionCause)ObjectSelect.query(ExceptionCause.class).where(ExceptionCause.ID.eq((Object)exceptionCauseId)).selectOne(context);
    }
}

