/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.PrimitiveAssert;

public final class BooleanAssert
extends PrimitiveAssert {
    private final boolean actual;

    BooleanAssert(boolean actual) {
        this.actual = actual;
    }

    public BooleanAssert as(String description) {
        this.description(description);
        return this;
    }

    public BooleanAssert describedAs(String description) {
        return this.as(description);
    }

    public BooleanAssert as(Description description) {
        this.description(description);
        return this;
    }

    public BooleanAssert describedAs(Description description) {
        return this.as(description);
    }

    public void isTrue() {
        this.isEqualTo(true);
    }

    public void isFalse() {
        this.isEqualTo(false);
    }

    public BooleanAssert isEqualTo(boolean expected) {
        Fail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public BooleanAssert isNotEqualTo(boolean other) {
        Fail.failIfEqual(this.description(), this.actual, other);
        return this;
    }
}

