/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ConstructorInvoker;

public final class ComparisonFailureFactory {
    private static ConstructorInvoker constructorInvoker = new ConstructorInvoker();

    static void constructorInvoker(ConstructorInvoker newConstructorInvoker) {
        constructorInvoker = newConstructorInvoker;
    }

    public static AssertionError comparisonFailure(String message, Object expected, Object actual) {
        if (ComparisonFailureFactory.isNotString(expected) || ComparisonFailureFactory.isNotString(actual)) {
            return null;
        }
        try {
            return ComparisonFailureFactory.newComparisonFailure(ComparisonFailureFactory.clean(message), (String)expected, (String)actual);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String clean(String message) {
        return message == null ? "" : message;
    }

    private static boolean isNotString(Object o) {
        return !(o instanceof String);
    }

    private static AssertionError newComparisonFailure(String message, String expected, String actual) throws Exception {
        String className = "org.junit.ComparisonFailure";
        Class[] parameterTypes = new Class[]{String.class, String.class, String.class};
        Object[] parameterValues = new Object[]{message, expected, actual};
        Object o = constructorInvoker.newInstance("org.junit.ComparisonFailure", parameterTypes, parameterValues);
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private ComparisonFailureFactory() {
    }
}

