/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortArrayAssert
extends ArrayAssert<short[]> {
    ShortArrayAssert(short ... actual) {
        super(actual);
    }

    public ShortArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public ShortArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public ShortArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ShortArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ShortArrayAssert contains(short ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public ShortArrayAssert containsOnly(short ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public ShortArrayAssert excludes(short ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((short[])this.actual);
    }

    private List<Object> list(short[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (short value : values) {
            list.add(value);
        }
        return list;
    }

    public ShortArrayAssert satisfies(Condition<short[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ShortArrayAssert doesNotSatisfy(Condition<short[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ShortArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public ShortArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public ShortArrayAssert isEqualTo(short[] expected) {
        if (!Arrays.equals((short[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public ShortArrayAssert isNotEqualTo(short[] array) {
        if (Arrays.equals((short[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public ShortArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((short[])this.actual).length;
    }

    public ShortArrayAssert isSameAs(short[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ShortArrayAssert isNotSameAs(short[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

