/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArrayAssert
extends ArrayAssert<boolean[]> {
    protected BooleanArrayAssert(boolean ... actual) {
        super(actual);
    }

    @Override
    public BooleanArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public BooleanArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public BooleanArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public BooleanArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public BooleanArrayAssert contains(boolean ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public BooleanArrayAssert containsOnly(boolean ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public BooleanArrayAssert excludes(boolean ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public BooleanArrayAssert satisfies(Condition<boolean[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public BooleanArrayAssert doesNotSatisfy(Condition<boolean[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public BooleanArrayAssert is(Condition<boolean[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public BooleanArrayAssert isNot(Condition<boolean[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public BooleanArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public BooleanArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public BooleanArrayAssert isEqualTo(boolean[] expected) {
        if (Arrays.equals((boolean[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public BooleanArrayAssert isNotEqualTo(boolean[] array) {
        if (!Arrays.equals((boolean[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public BooleanArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public BooleanArrayAssert isSameAs(boolean[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public BooleanArrayAssert isNotSameAs(boolean[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public BooleanArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

