/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupAssert<T>
extends GenericAssert<T> {
    protected GroupAssert(T actual) {
        super(actual);
    }

    public void isNullOrEmpty() {
        if (this.actual == null || !this.hasElements()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting null or empty, but was:", Formatting.inBrackets(this.actual)}));
    }

    public void isEmpty() {
        this.isNotNull();
        if (!this.hasElements()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting empty, but was:", Formatting.inBrackets(this.actual)}));
    }

    private boolean hasElements() {
        return this.actualGroupSize() > 0;
    }

    protected abstract GroupAssert<T> isNotEmpty();

    protected final void assertIsNotEmpty() {
        this.isNotNull();
        if (this.hasElements()) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting non-empty, but it was empty");
    }

    protected abstract GroupAssert<T> hasSize(int var1);

    protected final void assertHasSize(int expected) {
        this.isNotNull();
        int size = this.actualGroupSize();
        if (size == expected) {
            return;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(size), " for ", Formatting.inBrackets(this.actual)}));
    }

    protected abstract int actualGroupSize();

    @Override
    protected abstract GroupAssert<T> as(String var1);

    @Override
    protected abstract GroupAssert<T> describedAs(String var1);

    @Override
    protected abstract GroupAssert<T> as(Description var1);

    @Override
    protected abstract GroupAssert<T> describedAs(Description var1);

    @Override
    protected abstract GroupAssert<T> overridingErrorMessage(String var1);
}

