/*
 * Decompiled with CFR 0.152.
 */
package org.fest.mocks;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Enhancer;
import org.easymock.classextension.EasyMock;
import org.fest.mocks.UnexpectedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EasyMockTemplate {
    private final List<Object> mocks = new ArrayList<Object>();

    public EasyMockTemplate(Object ... mocks) {
        if (mocks == null) {
            throw new IllegalArgumentException("The list of mock objects should not be null");
        }
        if (mocks.length == 0) {
            throw new IllegalArgumentException("The list of mock objects should not be empty");
        }
        Object[] objectArray = mocks;
        int n = mocks.length;
        int n2 = 0;
        while (n2 < n) {
            Object mock = objectArray[n2];
            if (mock == null) {
                throw new IllegalArgumentException("The list of mocks should not include null values");
            }
            this.mocks.add(this.checkAndReturnMock(mock));
            ++n2;
        }
    }

    private Object checkAndReturnMock(Object mock) {
        if (Enhancer.isEnhanced(mock.getClass())) {
            return mock;
        }
        if (Proxy.isProxyClass(mock.getClass())) {
            return mock;
        }
        throw new IllegalArgumentException(mock + " is not a mock");
    }

    public final void run() {
        try {
            this.setUp();
            this.expectations();
            for (Object mock : this.mocks) {
                EasyMock.replay((Object[])new Object[]{mock});
            }
            this.codeToTest();
            for (Object mock : this.mocks) {
                EasyMock.verify((Object[])new Object[]{mock});
            }
            this.cleanUp();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UnexpectedError(t);
        }
    }

    protected final List<Object> mocks() {
        return new ArrayList<Object>(this.mocks);
    }

    protected abstract void expectations() throws Throwable;

    protected abstract void codeToTest() throws Throwable;

    protected void setUp() throws Throwable {
    }

    protected void cleanUp() throws Throwable {
    }
}

