/*
 * Created on Feb 6, 2008
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Copyright @2008-2009 the original author or authors.
 */
package org.fest.reflect.method;

/**
 * Understands a template for the return type of the method to invoke.
 *
 * @author Alex Ruiz
 */
abstract class ReturnTypeTemplate<T> {

  final String methodName;
  
  ReturnTypeTemplate(Class<T> type, NameTemplate methodName) {
    if (type == null) throw new NullPointerException("The return type of the method to access should not be null");
    this.methodName = methodName.name;
  }
}
