/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import org.fest.reflect.field.Invoker;
import org.fest.reflect.field.NameTemplate;
import org.fest.reflect.reference.TypeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypeRefTemplate<T> {
    private final TypeRef<T> type;
    private final String name;

    TypeRefTemplate(TypeRef<T> type, NameTemplate fieldName) {
        this.name = fieldName.name;
        if (type == null) {
            throw new NullPointerException("The type reference of the field to access should not be null");
        }
        this.type = type;
    }

    final Invoker<T> fieldInvoker(Object target, Class<?> declaringType) {
        Invoker invoker = new Invoker(this.name, target);
        invoker.verifyCorrectType(this.type);
        return invoker;
    }

    final Invoker<T> fieldInvoker(Class<?> target, Class<?> declaringType) {
        Invoker invoker = new Invoker(this.name, target);
        invoker.verifyCorrectType(this.type);
        return invoker;
    }
}

