/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import org.fest.reflect.innerclass.Invoker;
import org.fest.util.Strings;

public final class StaticInnerClassName {
    private final String name;

    public static StaticInnerClassName startStaticInnerClassAccess(String name) {
        StaticInnerClassName.validateIsNotNullOrEmpty(name);
        return new StaticInnerClassName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static inner class to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the static inner class to access should not be empty");
        }
    }

    private StaticInnerClassName(String name) {
        this.name = name;
    }

    public Invoker in(Class<?> declaringClass) {
        return Invoker.newInvoker(declaringClass, this.name);
    }
}

