/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import org.fest.reflect.method.Invoker;
import org.fest.reflect.method.StaticMethodParameterTypes;
import org.fest.reflect.method.StaticMethodReturnType;
import org.fest.reflect.method.StaticMethodReturnTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

public final class StaticMethodName {
    private final String name;

    public static StaticMethodName startStaticMethodAccess(String name) {
        StaticMethodName.validateIsNotNullOrEmpty(name);
        return new StaticMethodName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static method to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the static method to access should not be empty");
        }
    }

    private StaticMethodName(String name) {
        this.name = name;
    }

    public <T> StaticMethodReturnType<T> withReturnType(Class<T> type) {
        return StaticMethodReturnType.newReturnType(this.name, type);
    }

    public <T> StaticMethodReturnTypeRef<T> withReturnType(TypeRef<T> type) {
        return StaticMethodReturnTypeRef.newReturnTypeRef(this.name, type);
    }

    public StaticMethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return StaticMethodParameterTypes.newParameterTypes(this.name, parameterTypes);
    }

    public Invoker<Void> in(Class<?> target) {
        return Invoker.newInvoker(this.name, target, new Class[0]);
    }
}

