/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.io.OutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.fest.swing.junit.ant.EnvironmentXmlNodeWriter;
import org.fest.swing.junit.ant.SuiteXmlNodeWriter;
import org.fest.swing.junit.ant.TestCollection;
import org.fest.swing.junit.ant.TestXmlNodeWriter;
import org.fest.swing.junit.ant.XmlOutputWriter;
import org.fest.swing.junit.xml.XmlDocument;
import org.fest.swing.junit.xml.XmlNode;

public class XmlJUnitResultFormatter
implements JUnitResultFormatter {
    private XmlNode xmlRoot;
    private OutputStream out;
    private final TestCollection tests = new TestCollection();
    private final SuiteXmlNodeWriter suiteXmlNodeWriter = new SuiteXmlNodeWriter();
    private final EnvironmentXmlNodeWriter environmentXmlNodeWriter = new EnvironmentXmlNodeWriter();
    private final TestXmlNodeWriter testXmlNodeWriter = new TestXmlNodeWriter();
    private final XmlOutputWriter xmlOutputWriter = new XmlOutputWriter();

    final TestCollection tests() {
        return this.tests;
    }

    public final void setOutput(OutputStream out) {
        this.out = out;
    }

    public final void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public final void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    private void formatOutput(String type, String output) {
        this.xmlRoot.addNewNode(type).addCdata(output);
    }

    protected final XmlNode xmlRootNode() {
        return this.xmlRoot;
    }

    public final void startTestSuite(JUnitTest suite) {
        XmlDocument document = new XmlDocument();
        this.xmlRoot = document.newRoot("testsuite");
        this.suiteXmlNodeWriter.writeSuiteName(this.xmlRoot, suite).writeSuiteProperties(this.xmlRoot, suite);
        this.environmentXmlNodeWriter.writeHostName(this.xmlRoot).writeTimestamp(this.xmlRoot);
        this.onStartTestSuite(suite);
    }

    protected void onStartTestSuite(JUnitTest suite) {
    }

    public final void endTestSuite(JUnitTest suite) {
        this.suiteXmlNodeWriter.writeSuiteStatistics(this.xmlRoot, suite);
        if (this.out == null) {
            return;
        }
        this.xmlOutputWriter.write(this.xmlRoot, this.out);
    }

    public final void startTest(Test test) {
        this.tests.started(test);
    }

    public final void endTest(Test test) {
        if (!this.tests.wasStarted(test)) {
            this.startTest(test);
        }
        XmlNode testNode = this.xmlNodeForFinished(test);
        this.testXmlNodeWriter.writeTestExecutionTime(testNode, this.tests.startTimeOf(test));
    }

    private XmlNode xmlNodeForFinished(Test test) {
        if (this.tests.wasFailed(test)) {
            return this.tests.xmlNodeFor(test);
        }
        XmlNode newTestXmlNode = this.testXmlNodeWriter.addNewTestXmlNode(this.xmlRoot, test);
        this.tests.addXmlNode(test, newTestXmlNode);
        return newTestXmlNode;
    }

    public final void addFailure(Test test, AssertionFailedError failedAssertion) {
        this.addFailure(test, (Throwable)failedAssertion);
    }

    public final void addFailure(Test test, Throwable error) {
        XmlNode errorXmlNode = this.formatError("failure", test, error);
        this.onFailureOrError(test, error, errorXmlNode);
    }

    public final void addError(Test test, Throwable error) {
        XmlNode errorXmlNode = this.formatError("error", test, error);
        this.onFailureOrError(test, error, errorXmlNode);
    }

    private XmlNode formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
            this.tests.failed(test);
        }
        XmlNode errorXmlNode = this.xmlForFailed(test).addNewNode(type);
        this.writeErrorAndStackTrace(error, errorXmlNode);
        return errorXmlNode;
    }

    private XmlNode xmlForFailed(Test test) {
        if (test != null) {
            return this.tests.xmlNodeFor(test);
        }
        return this.xmlRoot;
    }

    protected final void writeErrorAndStackTrace(Throwable error, XmlNode errorXmlNode) {
        this.testXmlNodeWriter.writeErrorAndStackTrace(errorXmlNode, error);
    }

    protected void onFailureOrError(Test test, Throwable error, XmlNode errorXmlNode) {
    }
}

