/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import org.ec4j.lint.api.LintUtils;

public class Location {
    private static final Location INITIAL = new Location(1, 1);
    private final int column;
    private final int line;

    public static Location initial() {
        return INITIAL;
    }

    public Location(int line, int column) {
        this.line = LintUtils.validateLineOrColumnNumber(line, "line");
        this.column = LintUtils.validateLineOrColumnNumber(column, "column");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.column != other.column) {
            return false;
        }
        return this.line == other.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.line;
        return result;
    }

    public Location shift(int count) {
        if (count == 0) {
            return this;
        }
        return new Location(this.line, this.column + count);
    }

    public String toString() {
        return "" + this.line + "," + this.column;
    }
}

