/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public interface Logger {
    public static final Logger NO_OP = new NoOpLogger();

    public void debug(String var1, Object ... var2);

    public void error(String var1, Object ... var2);

    public void info(String var1, Object ... var2);

    public boolean isDebugEnabled();

    public boolean isErrorEnabled();

    public boolean isInfoEnabled();

    public boolean isLogLevelEnabled(LogLevel var1);

    public boolean isTraceEnabled();

    public boolean isWarnEnabled();

    public void log(LogLevel var1, String var2, Object ... var3);

    public void trace(String var1, Object ... var2);

    public void warn(String var1, Object ... var2);

    public static class Slf4jFormatter {
        static final char DELIM_START = '{';
        static final char DELIM_STOP = '}';
        static final String DELIM_STR = "{}";
        private static final char ESCAPE_CHAR = '\\';

        private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void charArrayAppend(StringBuilder sbuf, char[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
            if (o == null) {
                sbuf.append("null");
                return;
            }
            if (!o.getClass().isArray()) {
                Slf4jFormatter.safeObjectAppend(sbuf, o);
            } else if (o instanceof boolean[]) {
                Slf4jFormatter.booleanArrayAppend(sbuf, (boolean[])o);
            } else if (o instanceof byte[]) {
                Slf4jFormatter.byteArrayAppend(sbuf, (byte[])o);
            } else if (o instanceof char[]) {
                Slf4jFormatter.charArrayAppend(sbuf, (char[])o);
            } else if (o instanceof short[]) {
                Slf4jFormatter.shortArrayAppend(sbuf, (short[])o);
            } else if (o instanceof int[]) {
                Slf4jFormatter.intArrayAppend(sbuf, (int[])o);
            } else if (o instanceof long[]) {
                Slf4jFormatter.longArrayAppend(sbuf, (long[])o);
            } else if (o instanceof float[]) {
                Slf4jFormatter.floatArrayAppend(sbuf, (float[])o);
            } else if (o instanceof double[]) {
                Slf4jFormatter.doubleArrayAppend(sbuf, (double[])o);
            } else {
                Slf4jFormatter.objectArrayAppend(sbuf, (Object[])o, seenMap);
            }
        }

        private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        public static String format(String message, Object ... params) {
            int i = 0;
            StringBuilder result = new StringBuilder(message.length() + 50);
            for (int L = 0; L < params.length; ++L) {
                int j = message.indexOf(DELIM_STR, i);
                if (j == -1) {
                    if (i == 0) {
                        return message;
                    }
                    result.append(message, i, message.length());
                    return result.toString();
                }
                if (Slf4jFormatter.isEscapedDelimeter(message, j)) {
                    if (!Slf4jFormatter.isDoubleEscaped(message, j)) {
                        --L;
                        result.append(message, i, j - 1);
                        result.append('{');
                        i = j + 1;
                        continue;
                    }
                    result.append(message, i, j - 1);
                    Slf4jFormatter.deeplyAppendParameter(result, params[L], new HashMap<Object[], Object>());
                    i = j + 2;
                    continue;
                }
                result.append(message, i, j);
                Slf4jFormatter.deeplyAppendParameter(result, params[L], new HashMap<Object[], Object>());
                i = j + 2;
            }
            result.append(message, i, message.length());
            return result.toString();
        }

        private static void intArrayAppend(StringBuilder sbuf, int[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
            return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
        }

        private static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
            if (delimeterStartIndex == 0) {
                return false;
            }
            char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
            return potentialEscape == '\\';
        }

        private static void longArrayAppend(StringBuilder sbuf, long[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }

        private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
            sbuf.append('[');
            if (!seenMap.containsKey(a)) {
                seenMap.put(a, null);
                int len = a.length;
                for (int i = 0; i < len; ++i) {
                    Slf4jFormatter.deeplyAppendParameter(sbuf, a[i], seenMap);
                    if (i == len - 1) continue;
                    sbuf.append(", ");
                }
                seenMap.remove(a);
            } else {
                sbuf.append("...");
            }
            sbuf.append(']');
        }

        private static void safeObjectAppend(StringBuilder sbuf, Object o) {
            try {
                String oAsString = o.toString();
                sbuf.append(oAsString);
            }
            catch (Throwable t) {
                sbuf.append("[FAILED toString()]");
            }
        }

        private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
            sbuf.append('[');
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(a[i]);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(']');
        }
    }

    public static class NoOpLogger
    implements Logger {
        @Override
        public void debug(String string, Object ... args) {
        }

        @Override
        public void error(String string, Object ... args) {
        }

        @Override
        public void info(String string, Object ... args) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public boolean isLogLevelEnabled(LogLevel level) {
            return false;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public void log(LogLevel level, String string, Object ... args) {
        }

        @Override
        public void trace(String string, Object ... args) {
        }

        @Override
        public void warn(String string, Object ... args) {
        }
    }

    public static interface LogLevelSupplier {
        public LogLevel getLogLevel();

        public static class LogLevelSuppliers {
            public static LogLevelSupplier constant(final LogLevel logLevel) {
                return new LogLevelSupplier(){

                    @Override
                    public LogLevel getLogLevel() {
                        return logLevel;
                    }
                };
            }
        }
    }

    public static enum LogLevel {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    public static class AppendableLogger
    extends AbstractLogger {
        private final Appendable out;

        public AppendableLogger(LogLevel level, Appendable out) {
            super(level);
            this.out = out;
        }

        public AppendableLogger(LogLevelSupplier levelSupplier, Appendable out) {
            super(levelSupplier);
            this.out = out;
        }

        @Override
        public void log(LogLevel level, String string, Object ... args) {
            if (this.isLogLevelEnabled(level)) {
                try {
                    this.out.append(Slf4jFormatter.format(string, args)).append('\n');
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static abstract class AbstractLogger
    implements Logger {
        private final LogLevelSupplier levelSupplier;

        @Deprecated
        public AbstractLogger(LogLevel level) {
            this(LogLevelSupplier.LogLevelSuppliers.constant(level));
        }

        public AbstractLogger(LogLevelSupplier levelSupplier) {
            this.levelSupplier = levelSupplier;
        }

        @Override
        public void debug(String string, Object ... args) {
            this.log(LogLevel.DEBUG, string, args);
        }

        @Override
        public void error(String string, Object ... args) {
            this.log(LogLevel.ERROR, string, args);
        }

        @Override
        public void info(String string, Object ... args) {
            this.log(LogLevel.INFO, string, args);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isLogLevelEnabled(LogLevel.DEBUG);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isLogLevelEnabled(LogLevel.ERROR);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isLogLevelEnabled(LogLevel.INFO);
        }

        @Override
        public boolean isLogLevelEnabled(LogLevel level) {
            return this.levelSupplier.getLogLevel().ordinal() >= level.ordinal();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isLogLevelEnabled(LogLevel.TRACE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isLogLevelEnabled(LogLevel.WARN);
        }

        @Override
        public void trace(String string, Object ... args) {
            this.log(LogLevel.TRACE, string, args);
        }

        @Override
        public void warn(String string, Object ... args) {
            this.log(LogLevel.WARN, string, args);
        }
    }
}

