/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ec4j.lint.api.Edit;
import org.ec4j.lint.api.Linter;
import org.ec4j.lint.api.Location;
import org.ec4j.lint.api.Resource;

public class Violation {
    private final Edit fix;
    private final Location location;
    private final Resource resource;
    private String toString;
    private final Linter linter;
    private final List<String> violatedProperties;

    Violation(Resource resource, Location location, Edit fix, Linter linter, String ... violatedProperties) {
        this.resource = resource;
        this.location = location;
        this.fix = fix;
        this.linter = linter;
        this.violatedProperties = Collections.unmodifiableList(Arrays.asList(violatedProperties));
    }

    public Violation(Resource resource, Location location, Edit fix, Linter linter, String violatedKey0) {
        this(resource, location, fix, linter, new String[]{violatedKey0});
    }

    public Violation(Resource resource, Location location, Edit fix, Linter linter, String violatedKey0, String violatedValue0) {
        this(resource, location, fix, linter, new String[]{violatedKey0, violatedValue0});
    }

    public Violation(Resource resource, Location location, Edit fix, Linter linter, String violatedKey0, String violatedValue0, String violatedKey1, String violatedValue1) {
        this(resource, location, fix, linter, new String[]{violatedKey0, violatedValue0, violatedKey1, violatedValue1});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Violation other = (Violation)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.fix == null ? other.fix != null : !this.fix.equals(other.fix)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.linter == null ? other.linter != null : !this.linter.equals(other.linter)) {
            return false;
        }
        return !(this.violatedProperties == null ? other.violatedProperties != null : !this.violatedProperties.equals(other.violatedProperties));
    }

    public Edit getFix() {
        return this.fix;
    }

    public Location getLocation() {
        return this.location;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.fix == null ? 0 : this.fix.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.linter == null ? 0 : this.linter.hashCode());
        result = 31 * result + (this.violatedProperties == null ? 0 : this.violatedProperties.hashCode());
        return result;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder result = new StringBuilder().append(this.resource).append("@").append(this.location).append(": ").append(this.fix.getMessage()).append(" - violates ");
            Iterator<String> it = this.violatedProperties.iterator();
            while (it.hasNext()) {
                result.append(it.next());
                if (it.hasNext()) {
                    result.append(" = ").append(it.next());
                }
                result.append(", ");
            }
            this.toString = result.append("reported by ").append(this.linter.getClass().getName()).toString();
        }
        return this.toString;
    }
}

