/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.linters;

import java.util.BitSet;
import org.ec4j.lint.api.LintUtils;

public class Indent {
    public static final Indent START = new Indent(1, 0, -1, 0);
    private final int badLength;
    private final int badStartColumn;
    private final int lineNumber;
    private final int size;

    public static Indent of(int lineNumber, int size, BitSet edits, int editsLength) {
        if (editsLength == 0) {
            return new Indent(lineNumber, size, -1, 0);
        }
        int badStartColumn = 1;
        int badLength = editsLength;
        for (int i = editsLength - 1; i >= 0 && !edits.get(i); --i) {
            --badLength;
            ++badStartColumn;
        }
        return new Indent(lineNumber, size, badStartColumn, badLength);
    }

    Indent(int lineNumber, int size, int badStartColumn, int badLength) {
        this.lineNumber = LintUtils.validateLineOrColumnNumber((int)lineNumber, (String)"line");
        this.size = LintUtils.validateLength((int)size, (String)"size");
        this.badStartColumn = badStartColumn;
        this.badLength = LintUtils.validateLength((int)badLength, (String)"badLenght");
    }

    public String toString() {
        return "Indent [lineNumber=" + this.lineNumber + ", size=" + this.size + ", badLength=" + this.badLength + ", badStartColumn=" + this.badStartColumn + "]";
    }

    public int getBadLength() {
        return this.badLength;
    }

    public int getBadStartColumn() {
        assert (this.badLength == 0 || this.badStartColumn >= 1) : "badStartColumn must be greater or equal to 1 unless badLength is 0";
        return this.badStartColumn;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSize() {
        return this.size;
    }
}

