/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.linters;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.PropertyType;
import org.ec4j.lint.api.Delete;
import org.ec4j.lint.api.Edit;
import org.ec4j.lint.api.FormatException;
import org.ec4j.lint.api.Insert;
import org.ec4j.lint.api.LineReader;
import org.ec4j.lint.api.Linter;
import org.ec4j.lint.api.Location;
import org.ec4j.lint.api.Logger;
import org.ec4j.lint.api.Replace;
import org.ec4j.lint.api.Resource;
import org.ec4j.lint.api.Violation;
import org.ec4j.lint.api.ViolationHandler;

public class TextLinter
implements Linter {
    private static final List<String> DEFAULT_EXCLUDES = Collections.emptyList();
    private static final List<String> DEFAULT_INCLUDES = Collections.unmodifiableList(Arrays.asList("**/*"));
    private static final Pattern TRAILING_WHITESPACE_PATTERN = Pattern.compile("[ \t]+$", 8);

    static String escape(String line, PropertyType.EndOfLineValue eol) {
        String escapedEol;
        if (eol == null) {
            return line;
        }
        switch (eol) {
            case lf: {
                escapedEol = "\\n";
                break;
            }
            case crlf: {
                escapedEol = "\\r\\n";
                break;
            }
            case cr: {
                escapedEol = "\\r";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + PropertyType.EndOfLineValue.class.getName() + " '" + eol + "'");
            }
        }
        return line.substring(0, line.length() - eol.getEndOfLineString().length()) + escapedEol;
    }

    static String findEolString(String line) {
        int start;
        if (line.isEmpty()) {
            return "";
        }
        block3: for (start = line.length(); start > 0; --start) {
            char ch = line.charAt(start - 1);
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block3;
                }
            }
            return line.substring(start);
        }
        return line.substring(start);
    }

    public List<String> getDefaultExcludes() {
        return DEFAULT_EXCLUDES;
    }

    public List<String> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    public void process(Resource resource, ResourceProperties properties, ViolationHandler violationHandler) throws IOException {
        Logger log = violationHandler.getLogger();
        PropertyType.EndOfLineValue eol = (PropertyType.EndOfLineValue)properties.getValue(PropertyType.end_of_line, null, true);
        Boolean trimTrailingWsBox = (Boolean)properties.getValue(PropertyType.trim_trailing_whitespace, (Object)Boolean.FALSE, true);
        boolean trimTrailingWs = trimTrailingWsBox != null && trimTrailingWsBox != false;
        boolean insertFinalNewline = (Boolean)properties.getValue(PropertyType.insert_final_newline, (Object)Boolean.FALSE, false);
        if (log.isTraceEnabled()) {
            log.trace("Checking end_of_line value '{}' in {}", new Object[]{eol, resource});
            log.trace("Checking trim_trailing_whitespace value '{}' in {}", new Object[]{trimTrailingWsBox, resource});
            log.trace("Checking insert_final_newline value '{}' in {}", new Object[]{insertFinalNewline, resource});
        }
        try (LineReader in = LineReader.of((Reader)resource.openReader());){
            String line = null;
            String lastActualEol = null;
            String lastLine = null;
            int lineNumber = 1;
            while ((line = in.readLine()) != null) {
                block32: {
                    Replace fix;
                    int column;
                    block34: {
                        block35: {
                            int eolLength;
                            int actualEolLength;
                            block33: {
                                Matcher m;
                                if (log.isTraceEnabled()) {
                                    String actualEol = TextLinter.findEolString(line);
                                    log.trace("Processing line '{}'", new Object[]{TextLinter.escape(line, actualEol == null ? null : PropertyType.EndOfLineValue.ofEndOfLineString((String)actualEol))});
                                }
                                lastLine = line;
                                if (trimTrailingWs && (m = TRAILING_WHITESPACE_PATTERN.matcher(line)).find()) {
                                    int start = m.start();
                                    Violation violation = new Violation(resource, new Location(lineNumber, start + 1), (Edit)new Delete(m.end() - start), (Linter)this, PropertyType.trim_trailing_whitespace.getName(), "true");
                                    violationHandler.handle(violation);
                                }
                                if (eol == null) break block32;
                                lastActualEol = TextLinter.findEolString(line);
                                String eolString = eol.getEndOfLineString();
                                if (eolString.equals(lastActualEol)) break block32;
                                actualEolLength = lastActualEol.length();
                                eolLength = eolString.length();
                                if (actualEolLength == 0) break block32;
                                if (actualEolLength != eolLength) break block33;
                                column = line.length();
                                fix = Replace.endOfLine((PropertyType.EndOfLineValue)PropertyType.EndOfLineValue.ofEndOfLineString((String)lastActualEol), (PropertyType.EndOfLineValue)eol);
                                break block34;
                            }
                            if (actualEolLength >= eolLength) break block35;
                            switch (lastActualEol.charAt(0)) {
                                case '\r': {
                                    column = line.length() + 1;
                                    fix = Insert.endOfLine((PropertyType.EndOfLineValue)PropertyType.EndOfLineValue.lf);
                                    break block34;
                                }
                                case '\n': {
                                    column = line.length();
                                    fix = Insert.endOfLine((PropertyType.EndOfLineValue)PropertyType.EndOfLineValue.cr);
                                    break block34;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        fix = new Delete(1);
                        switch (eol) {
                            case cr: {
                                column = line.length();
                                break;
                            }
                            case lf: {
                                column = line.length() - 1;
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    Violation violation = new Violation(resource, new Location(lineNumber, column), (Edit)fix, (Linter)this, PropertyType.end_of_line.getName(), eol.name());
                    violationHandler.handle(violation);
                }
                ++lineNumber;
            }
            if (insertFinalNewline && lastLine != null) {
                if (lastActualEol == null) {
                    lastActualEol = TextLinter.findEolString(lastLine);
                }
                --lineNumber;
                int col = lastLine.length() + 1;
                if (lastActualEol.isEmpty()) {
                    if (eol == null) {
                    } else {
                        Violation insertFinalNewlineViolation = new Violation(resource, new Location(lineNumber, col), (Edit)Insert.endOfLine((PropertyType.EndOfLineValue)eol), (Linter)this, PropertyType.insert_final_newline.getName(), "true");
                        violationHandler.handle(insertFinalNewlineViolation);
                    }
                }
            }
        }
        catch (MalformedInputException e) {
            throw new FormatException("Could not read " + resource.getPath() + ". This may mean that it is a binary file and you should exclude it from editorconfig processing.", (Throwable)e);
        }
    }
}

