/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ec4j.maven.lint.api.Edit;
import org.ec4j.maven.lint.api.EditableResource;
import org.ec4j.maven.lint.api.FormatException;
import org.ec4j.maven.lint.api.Location;
import org.ec4j.maven.lint.api.Resource;
import org.ec4j.maven.lint.api.Violation;
import org.ec4j.maven.lint.api.ViolationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattingHandler
implements ViolationHandler {
    private static final Logger log = LoggerFactory.getLogger(FormattingHandler.class);
    private final boolean backup;
    private final String backupSuffix;
    private EditableResource currentFile;
    private int editedFileCount = 0;
    private int processedFileCount = 0;
    private List<Violation> violations = new ArrayList<Violation>();

    public FormattingHandler(boolean backup, String backupSuffix) {
        this.backup = backup;
        this.backupSuffix = backupSuffix;
    }

    private void backupAndStoreIfNeeded() throws IOException {
        if (this.currentFile.changed()) {
            if (this.backup) {
                Path originalFile = this.currentFile.getPath();
                Path backupFile = Paths.get(String.valueOf(originalFile.toString()) + this.backupSuffix, new String[0]);
                Files.move(originalFile, backupFile, new CopyOption[0]);
            }
            this.currentFile.store();
        }
    }

    @Override
    public ViolationHandler.ReturnState endFile() {
        try {
            if (this.violations.isEmpty()) {
                log.debug("No formatting violations found in file '{}' ", (Object)this.currentFile);
                this.backupAndStoreIfNeeded();
                ViolationHandler.ReturnState returnState = ViolationHandler.ReturnState.FINISHED;
                return returnState;
            }
            if (log.isDebugEnabled()) {
                log.debug("Fixing {} formatting {}  in file '{}'", new Object[]{this.violations.size(), this.violations.size() == 1 ? "violation" : "violations", this.currentFile});
            }
            ++this.editedFileCount;
            HashSet<Integer> linesEdited = new HashSet<Integer>();
            boolean recheckNeeded = false;
            for (Violation violation : this.violations) {
                Location loc = violation.getLocation();
                Integer line = loc.getLine();
                if (!linesEdited.contains(line)) {
                    int lineStartOffset = this.currentFile.findLineStart(loc.getLine());
                    int editOffset = lineStartOffset + loc.getColumn() - 1;
                    Edit fix = violation.getFix();
                    log.debug("About to perform '{}' at {}, lineStartOffset {}, editOffset {}", new Object[]{fix.getMessage(), loc, lineStartOffset, editOffset});
                    fix.perform(this.currentFile, editOffset);
                    linesEdited.add(line);
                    continue;
                }
                recheckNeeded = true;
            }
            if (recheckNeeded) {
                ViolationHandler.ReturnState returnState = ViolationHandler.ReturnState.RECHECK;
                return returnState;
            }
            this.backupAndStoreIfNeeded();
            ViolationHandler.ReturnState returnState = ViolationHandler.ReturnState.FINISHED;
            return returnState;
        }
        catch (IOException e) {
            throw new FormatException("Could not format file " + this.currentFile, e);
        }
        finally {
            ++this.processedFileCount;
            this.currentFile = null;
            this.violations.clear();
        }
    }

    @Override
    public void endFiles() {
        log.info("Formatted {} out of {} {}", new Object[]{this.editedFileCount, this.processedFileCount, this.editedFileCount == 1 ? "file" : "files"});
    }

    @Override
    public void handle(Violation violation) {
        log.info(violation.toString());
        this.violations.add(violation);
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    @Override
    public void startFile(Resource file) {
        this.currentFile = (EditableResource)file;
    }

    @Override
    public void startFiles() {
        this.processedFileCount = 0;
    }
}

