/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public abstract class LineReader
extends Reader {
    public static LineReader of(Reader delegate) {
        return new DelegatingLineReader(delegate);
    }

    public static LineReader of(StringBuilder text) {
        return new StringBuilderReader(text);
    }

    public abstract String readLine() throws IOException;

    static class DelegatingLineReader
    extends LineReader {
        private final Reader delegate;
        private int readAhead = -1;

        DelegatingLineReader(Reader delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.delegate.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public int read() throws IOException {
            if (this.readAhead >= 0) {
                int r = this.readAhead;
                this.readAhead = -1;
                return r;
            }
            return this.delegate.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            int len = cbuf.length;
            if (len == 0) {
                return 0;
            }
            if (this.readAhead >= 0 && len > 0) {
                cbuf[0] = (char)this.readAhead;
                this.readAhead = -1;
                int cnt = this.delegate.read(cbuf, 1, len - 1);
                return cnt + 1;
            }
            return this.delegate.read(cbuf);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.readAhead >= 0 && len > 0) {
                cbuf[0] = (char)this.readAhead;
                this.readAhead = -1;
                int cnt = this.delegate.read(cbuf, 1, len - 1);
                return cnt + 1;
            }
            return this.delegate.read(cbuf, off, len);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            int len = target.remaining();
            if (len == 0) {
                return 0;
            }
            char[] cbuf = new char[len];
            if (this.readAhead >= 0 && len > 0) {
                cbuf[0] = (char)this.readAhead;
                this.readAhead = -1;
                int cnt = this.delegate.read(cbuf, 1, len - 1);
                target.put(cbuf, 0, cnt + 1);
                return cnt + 1;
            }
            int cnt = this.delegate.read(cbuf, 1, len);
            if (cnt > 0) {
                target.put(cbuf, 0, cnt);
            }
            return cnt;
        }

        @Override
        public String readLine() throws IOException {
            int ch = this.read();
            if (ch < 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(120);
            do {
                switch (ch) {
                    case 13: {
                        sb.append((char)ch);
                        this.readAhead = this.read();
                        if (this.readAhead == 10) {
                            sb.append('\n');
                            this.readAhead = -1;
                        }
                        return sb.toString();
                    }
                    case 10: {
                        sb.append((char)ch);
                        return sb.toString();
                    }
                }
                sb.append((char)ch);
            } while ((ch = this.read()) >= 0);
            return sb.toString();
        }

        @Override
        public boolean ready() throws IOException {
            return this.readAhead >= 0 || this.delegate.ready();
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            if (n == 0L) {
                return 0L;
            }
            if (this.readAhead >= 0) {
                long cnt = this.delegate.skip(n);
                this.readAhead = -1;
                return cnt + 1L;
            }
            return this.delegate.skip(n);
        }
    }

    static class StringBuilderReader
    extends LineReader {
        private int mark = 0;
        private int offset = 0;
        private final StringBuilder text;

        StringBuilderReader(StringBuilder text) {
            this.text = text;
        }

        @Override
        public void close() {
            this.offset = 0;
            this.mark = 0;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.offset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (this.offset >= this.text.length()) {
                return -1;
            }
            return this.text.charAt(this.offset++);
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            if (this.offset >= this.text.length()) {
                return -1;
            }
            int srcEnd = Math.min(this.text.length(), this.offset + len);
            this.text.getChars(this.offset, srcEnd, cbuf, off);
            int count = srcEnd - this.offset;
            this.offset += count;
            return count;
        }

        @Override
        public String readLine() throws IOException {
            int len = this.text.length();
            if (this.offset >= len) {
                return null;
            }
            StringBuilder sb = new StringBuilder(120);
            while (this.offset < len) {
                char ch = this.text.charAt(this.offset++);
                switch (ch) {
                    case '\r': {
                        sb.append(ch);
                        if (this.offset < len && this.text.charAt(this.offset) == '\n') {
                            sb.append('\n');
                            ++this.offset;
                        }
                        return sb.toString();
                    }
                    case '\n': {
                        sb.append(ch);
                        return sb.toString();
                    }
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        @Override
        public void reset() {
            this.offset = this.mark;
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
            }
            if (this.offset >= this.text.length()) {
                return -1L;
            }
            int dest = (int)Math.min((long)this.text.length(), (long)this.offset + n);
            int count = dest - this.offset;
            this.offset = dest;
            return count;
        }

        public String toString() {
            return this.text.toString();
        }
    }
}

