/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathSet {
    private static final Path CURRENT_DIR = Paths.get(".", new String[0]);
    private final List<PathMatcher> excludes;
    private final List<PathMatcher> includes;

    public static Builder builder() {
        return new Builder();
    }

    public static PathSet ofIncludes(String ... includes) {
        return PathSet.builder().includes(includes).build();
    }

    PathSet(List<PathMatcher> includes, List<PathMatcher> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean contains(Path path) {
        path = CURRENT_DIR.resolve(path);
        for (PathMatcher exclude : this.excludes) {
            if (!exclude.matches(path)) continue;
            return false;
        }
        for (PathMatcher include : this.includes) {
            if (!include.matches(path)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private static final FileSystem fileSystem = FileSystems.getDefault();
        private List<PathMatcher> excludes = new ArrayList<PathMatcher>();
        private List<PathMatcher> includes = new ArrayList<PathMatcher>();

        Builder() {
        }

        public PathSet build() {
            List<PathMatcher> useExcludes = this.excludes;
            this.excludes = null;
            List<PathMatcher> useIncludes = this.includes;
            this.includes = null;
            return new PathSet(Collections.unmodifiableList(useIncludes), Collections.unmodifiableList(useExcludes));
        }

        public Builder exclude(String glob) {
            this.excludes.add(fileSystem.getPathMatcher("glob:" + glob));
            return this;
        }

        public Builder excludes(List<String> globs) {
            if (globs != null) {
                for (String glob : globs) {
                    this.excludes.add(fileSystem.getPathMatcher("glob:" + glob));
                }
            }
            return this;
        }

        public Builder excludes(String ... globs) {
            if (globs != null) {
                String[] stringArray = globs;
                int n = globs.length;
                int n2 = 0;
                while (n2 < n) {
                    String glob = stringArray[n2];
                    this.excludes.add(fileSystem.getPathMatcher("glob:" + glob));
                    ++n2;
                }
            }
            return this;
        }

        public Builder include(String glob) {
            this.includes.add(fileSystem.getPathMatcher("glob:" + glob));
            return this;
        }

        public Builder includes(List<String> globs) {
            for (String glob : globs) {
                this.includes.add(fileSystem.getPathMatcher("glob:" + glob));
            }
            return this;
        }

        public Builder includes(String ... globs) {
            if (globs != null) {
                String[] stringArray = globs;
                int n = globs.length;
                int n2 = 0;
                while (n2 < n) {
                    String glob = stringArray[n2];
                    this.includes.add(fileSystem.getPathMatcher("glob:" + glob));
                    ++n2;
                }
            }
            return this;
        }
    }
}

