/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ec4j.maven.lint.api.FormatException;
import org.ec4j.maven.lint.api.LineReader;
import org.ec4j.maven.lint.api.Resource;

public class EditableResource
extends Resource
implements CharSequence {
    private static final Pattern EOL_MATCHER = Pattern.compile("$", 8);
    private int hashCodeLoaded;
    StringBuilder text;

    public EditableResource(Path absPath, Path relPath, Charset encoding) {
        super(absPath, relPath, encoding);
    }

    public EditableResource(Path absPath, Path relPath, Charset encoding, String text) {
        super(absPath, relPath, encoding);
        this.text = new StringBuilder(text);
        this.hashCodeLoaded = text.hashCode();
    }

    public String asString() {
        this.ensureReadSilent();
        return this.text.toString();
    }

    public boolean changed() {
        int len = this.text.length();
        int hash = 0;
        int i = 0;
        while (i < len) {
            hash = 31 * hash + this.text.charAt(i);
            ++i;
        }
        return hash != this.hashCodeLoaded;
    }

    @Override
    public char charAt(int index) {
        this.ensureReadSilent();
        return this.text.charAt(index);
    }

    public void delete(int start, int end) {
        this.ensureReadSilent();
        this.text.delete(start, end);
    }

    private void ensureRead() throws IOException {
        if (this.text == null) {
            try (Reader r = null;){
                try {
                    int len;
                    r = super.openReader();
                    int hash = 0;
                    StringBuilder sb = new StringBuilder(256);
                    char[] cbuf = new char[1024];
                    while ((len = r.read(cbuf)) >= 0) {
                        sb.append(cbuf, 0, len);
                        int i = 0;
                        while (i < len) {
                            hash = 31 * hash + cbuf[i];
                            ++i;
                        }
                    }
                    this.text = sb;
                    this.hashCodeLoaded = hash;
                }
                catch (MalformedInputException e) {
                    throw new FormatException("Could not read " + this.absPath + ". This may mean that it is a binary file and you should exclude it from editorconfig processing.", e);
                }
            }
        }
    }

    private void ensureReadSilent() {
        try {
            this.ensureRead();
        }
        catch (IOException e) {
            throw new FormatException("Could not read " + this.absPath, e);
        }
    }

    public int findLineStart(int lineNumber) {
        this.ensureReadSilent();
        if (lineNumber == 1) {
            return 0;
        }
        int currentLine = 2;
        Matcher m = EOL_MATCHER.matcher(this.text);
        while (m.find()) {
            if (currentLine == lineNumber) {
                int len;
                int end = m.end();
                if (end < (len = this.text.length())) {
                    switch (this.text.charAt(end)) {
                        case '\n': {
                            return end + 1;
                        }
                        case '\r': {
                            if (++end < len && this.text.charAt(end) == '\n') {
                                return end + 1;
                            }
                            return end;
                        }
                    }
                }
                return end;
            }
            if (currentLine > lineNumber) {
                throw new IndexOutOfBoundsException("No such line " + lineNumber);
            }
            ++currentLine;
        }
        throw new IndexOutOfBoundsException("No such line " + lineNumber);
    }

    public void insert(int offset, CharSequence string) {
        this.ensureReadSilent();
        this.text.insert(offset, string);
    }

    @Override
    public int length() {
        this.ensureReadSilent();
        return this.text.length();
    }

    @Override
    public Reader openReader() throws IOException {
        this.ensureRead();
        return LineReader.of(this.text);
    }

    public void replace(int start, int end, String replacement) {
        this.ensureReadSilent();
        this.text.replace(start, end, replacement);
    }

    public void store() throws IOException {
        try (Writer w = null;){
            w = Files.newBufferedWriter(this.absPath, this.encoding, new OpenOption[0]);
            char[] cbuf = new char[1024];
            int len = this.text.length();
            int i = 0;
            while (i < len) {
                int srcEnd = Math.min(len, i + cbuf.length);
                this.text.getChars(i, srcEnd, cbuf, 0);
                w.write(cbuf, 0, srcEnd - i);
                i += srcEnd - i;
            }
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.ensureReadSilent();
        return this.text.subSequence(start, end);
    }
}

