/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.util.Arrays;
import org.ec4j.core.model.PropertyType;
import org.ec4j.maven.lint.api.Edit;
import org.ec4j.maven.lint.api.EditableResource;

public class Replace
implements Edit {
    private final String message;
    private final int replacedLength;
    private final String replacement;

    public static Replace endOfLine(PropertyType.EndOfLineValue replaced, PropertyType.EndOfLineValue replacement) {
        return new Replace(replaced.getEndOfLineString().length(), replacement.getEndOfLineString(), "Replace '" + replaced.name() + "' with '" + replacement.name() + "'");
    }

    public static Replace indent(int replacedLength, PropertyType.IndentStyleValue indentStyle, int replacementLength) {
        char[] replacementArr = new char[replacementLength];
        Arrays.fill(replacementArr, indentStyle.getIndentChar());
        return new Replace(replacedLength, new String(replacementArr), "Replace " + replacedLength + " characters with " + replacementLength + " " + indentStyle.name() + (replacedLength != 1 ? "s" : ""));
    }

    public static Replace ofReplaced(String replaced, String replacement) {
        return new Replace(replaced.length(), replacement, "Replace '" + replaced + "' with '" + replacement + "'");
    }

    public Replace(int replacedLength, String replacement, String message) {
        this.replacement = replacement;
        this.message = message;
        this.replacedLength = replacedLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replace replace = (Replace)o;
        if (this.replacedLength != replace.replacedLength) {
            return false;
        }
        if (this.replacement != null ? !this.replacement.equals(replace.replacement) : replace.replacement != null) {
            return false;
        }
        return this.message != null ? this.message.equals(replace.message) : replace.message == null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        int result = this.replacement != null ? this.replacement.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + this.replacedLength;
        return result;
    }

    @Override
    public void perform(EditableResource document, int offset) {
        document.replace(offset, offset + this.replacedLength, this.replacement);
    }
}

