/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven.lint.api;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

public class Resource {
    protected final Path absPath;
    protected final Charset encoding;
    protected final Path relPath;

    public Resource(Path absPath, Path relPath, Charset encoding) {
        this.absPath = absPath;
        this.relPath = relPath;
        this.encoding = encoding;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        return !(this.absPath == null ? other.absPath != null : !this.absPath.equals(other.absPath));
    }

    public Path getPath() {
        return this.absPath;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.absPath == null ? 0 : this.absPath.hashCode());
        return result;
    }

    public Reader openReader() throws IOException {
        return Files.newBufferedReader(this.absPath, this.encoding);
    }

    public String toString() {
        return this.relPath.toString();
    }
}

