/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.ec4j.core.Cache;
import org.ec4j.core.Resource;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.ResourcePropertiesService;
import org.ec4j.core.model.PropertyType;
import org.ec4j.lint.api.Constants;
import org.ec4j.lint.api.FormatException;
import org.ec4j.lint.api.Linter;
import org.ec4j.lint.api.LinterRegistry;
import org.ec4j.lint.api.Resource;
import org.ec4j.lint.api.ViolationHandler;
import org.ec4j.maven.LinterConfig;
import org.ec4j.maven.Slf4jLintLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditorConfigMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(AbstractEditorConfigMojo.class);
    @Parameter(property="editorconfig.addLintersFromClassPath", defaultValue="true")
    protected boolean addLintersFromClassPath;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File basedir;
    protected Path basedirPath;
    protected Charset charset;
    @Parameter(property="editorconfig.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="editorconfig.excludeNonSourceFiles", defaultValue="true")
    protected boolean excludeNonSourceFiles;
    @Parameter(property="editorconfig.excludes")
    protected String[] excludes;
    @Parameter(property="editorconfig.excludeSubmodules", defaultValue="true")
    protected boolean excludeSubmodules;
    @Parameter(property="editorconfig.failOnNoMatchingProperties", defaultValue="true")
    protected boolean failOnNoMatchingProperties;
    @Parameter(property="editorconfig.excludesFile")
    protected File excludesFile;
    @Parameter(property="editorconfig.includes", defaultValue="**")
    protected String[] includes;
    @Parameter
    protected List<LinterConfig> linters = new ArrayList<LinterConfig>();
    @Component
    public MavenProject project;
    @Parameter(property="editorconfig.skip", defaultValue="false")
    private boolean skip;

    private LinterRegistry buildLinterRegistry() {
        LinterRegistry.Builder linterRegistryBuilder = LinterRegistry.builder().log((org.ec4j.lint.api.Logger)new Slf4jLintLogger(LoggerFactory.getLogger(LinterRegistry.class)));
        if (this.addLintersFromClassPath) {
            linterRegistryBuilder.scan(((Object)((Object)this)).getClass().getClassLoader());
        }
        if (this.linters != null && !this.linters.isEmpty()) {
            for (LinterConfig linter : this.linters) {
                if (linter.isEnabled()) {
                    linterRegistryBuilder.entry(linter.getId(), linter.getClassName(), ((Object)((Object)this)).getClass().getClassLoader(), linter.getIncludes(), linter.getExcludes(), linter.isUseDefaultIncludesAndExcludes());
                    continue;
                }
                linterRegistryBuilder.removeEntry(linter.getId());
            }
        }
        return linterRegistryBuilder.build();
    }

    protected abstract ViolationHandler createHandler();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            log.debug("Skipping execution, as demanded by user.");
            return;
        }
        if (this.encoding == null || this.encoding.isEmpty()) {
            this.charset = Charset.defaultCharset();
            log.warn("Using current platform's default encoding {} to read .editorconfig files. You do not want this. Set either 'project.build.sourceEncoding' or 'editorconfig.encoding' property.", (Object)this.charset);
        } else {
            this.charset = Resource.Charsets.forName((String)this.encoding);
        }
        this.basedirPath = this.basedir.toPath();
        LinterRegistry linterRegistry = this.buildLinterRegistry();
        String[] includedFiles = this.scanIncludedFiles();
        try {
            ViolationHandler handler = this.createHandler();
            ResourcePropertiesService resourcePropertiesService = ResourcePropertiesService.builder().cache(Cache.Caches.permanent()).build();
            handler.startFiles();
            boolean propertyMatched = false;
            String[] stringArray = includedFiles;
            int n = includedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String includedPath = stringArray[n2];
                Path file = Paths.get(includedPath, new String[0]);
                Path absFile = this.basedirPath.resolve(file);
                log.debug("Processing file '{}'", (Object)file);
                ResourceProperties editorConfigProperties = resourcePropertiesService.queryProperties(Resource.Resources.ofPath((Path)absFile, (Charset)this.charset));
                if (!editorConfigProperties.getProperties().isEmpty()) {
                    propertyMatched = true;
                    Charset useEncoding = Resource.Charsets.forName((String)((String)editorConfigProperties.getValue(PropertyType.charset, (Object)this.encoding, true)));
                    if (log.isTraceEnabled()) {
                        log.trace("Creating a {} for path '{}' with encoding '{}'", new Object[]{Resource.class.getSimpleName(), file, useEncoding});
                    }
                    Resource resource = new Resource(absFile, file, useEncoding);
                    List filteredLinters = linterRegistry.filter(file);
                    ViolationHandler.ReturnState state = ViolationHandler.ReturnState.RECHECK;
                    while (state != ViolationHandler.ReturnState.FINISHED) {
                        for (Linter linter : filteredLinters) {
                            if (log.isTraceEnabled()) {
                                log.trace("Processing file '{}' using linter {}", (Object)file, (Object)linter.getClass().getName());
                            }
                            handler.startFile(resource);
                            linter.process(resource, editorConfigProperties, handler);
                        }
                        state = handler.endFile();
                    }
                }
                ++n2;
            }
            if (!propertyMatched) {
                if (this.failOnNoMatchingProperties) {
                    log.error("No .editorconfig properties applicable for files under '{}'", (Object)this.basedirPath);
                } else {
                    log.warn("No .editorconfig properties applicable for files under '{}'", (Object)this.basedirPath);
                }
            }
            handler.endFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (FormatException e) {
            throw new MojoFailureException("\n\n" + e.getMessage() + "\n\n", (Throwable)e);
        }
    }

    private String[] scanIncludedFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.basedir);
        scanner.setIncludes(AbstractEditorConfigMojo.appendSanitized(this.includes, new LinkedHashSet<String>()));
        LinkedHashSet<String> excls = new LinkedHashSet<String>();
        if (this.excludeNonSourceFiles) {
            excls.addAll(Constants.DEFAULT_EXCLUDES);
        }
        if (this.excludesFile != null) {
            log.debug("Using excludesFile '{}'", (Object)this.excludesFile);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = Files.newBufferedReader(this.excludesFile.toPath(), this.charset);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        excls.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading excludesFile '" + this.excludesFile + "'", e);
            }
        }
        if (this.excludeSubmodules && this.project != null) {
            List profiles;
            List modules = this.project.getModules();
            if (modules != null) {
                for (String module : modules) {
                    excls.add(String.valueOf(module) + "/**");
                }
            }
            if ((profiles = this.project.getModel().getProfiles()) != null) {
                for (Profile profile : profiles) {
                    List modules2 = profile.getModules();
                    if (modules2 == null) continue;
                    for (String module : modules2) {
                        excls.add(String.valueOf(module) + "/**");
                    }
                }
            }
        }
        scanner.setExcludes(AbstractEditorConfigMojo.appendSanitized(this.excludes, excls));
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    static String[] appendSanitized(String[] input, Collection<String> result) {
        if (input == null || input.length == 0) {
            return result.toArray(new String[0]);
        }
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && !(item = item.trim()).isEmpty()) {
                result.add(item);
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }
}

