/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.maven;

import org.ec4j.lint.api.Logger;
import org.slf4j.Logger;

public class Slf4jLintLogger
extends Logger.AbstractLogger {
    private final Logger delegate;

    static Logger.LogLevelSupplier toEc4jLogLevelSupplier(Logger log) {
        return () -> {
            if (log.isTraceEnabled()) {
                return Logger.LogLevel.TRACE;
            }
            if (log.isDebugEnabled()) {
                return Logger.LogLevel.DEBUG;
            }
            if (log.isInfoEnabled()) {
                return Logger.LogLevel.INFO;
            }
            if (log.isWarnEnabled()) {
                return Logger.LogLevel.WARN;
            }
            if (log.isErrorEnabled()) {
                return Logger.LogLevel.ERROR;
            }
            return Logger.LogLevel.NONE;
        };
    }

    public Slf4jLintLogger(Logger delegate) {
        super(Slf4jLintLogger.toEc4jLogLevelSupplier(delegate));
        this.delegate = delegate;
    }

    public void log(Logger.LogLevel level, String string, Object ... args) {
        switch (level) {
            case TRACE: {
                this.delegate.trace(string, args);
                break;
            }
            case DEBUG: {
                this.delegate.debug(string, args);
                break;
            }
            case INFO: {
                this.delegate.info(string, args);
                break;
            }
            case WARN: {
                this.delegate.warn(string, args);
                break;
            }
            case ERROR: {
                this.delegate.error(string, args);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + Logger.LogLevel.class.getName() + " [" + level + "]");
            }
        }
    }
}

