/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util;

import jakarta.mail.MessagingException;
import org.eclipse.angus.mail.util.SocketConnectException;

public class MailConnectException
extends MessagingException {
    private final String host;
    private final int port;
    private final int cto;
    private static final long serialVersionUID = -3818807731125317729L;

    public MailConnectException(SocketConnectException cex) {
        super("Couldn't connect to host, port: " + cex.getHost() + ", " + cex.getPort() + "; timeout " + cex.getConnectionTimeout() + (String)(cex.getMessage() != null ? "; " + cex.getMessage() : ""));
        this.host = cex.getHost();
        this.port = cex.getPort();
        this.cto = cex.getConnectionTimeout();
        super.setNextException(cex.getException());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectionTimeout() {
        return this.cto;
    }
}

