/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;
import org.eclipse.angus.mail.util.logging.LogManagerProperties;

public class DurationFilter
implements Filter {
    private long records;
    private long duration;
    private long count;
    private long peak;
    private long start;

    public DurationFilter() {
        this.records = DurationFilter.checkRecords(this.initLong(".records"));
        this.duration = DurationFilter.checkDuration(this.initLong(".duration"));
    }

    public DurationFilter(long records, long duration) {
        this.records = DurationFilter.checkRecords(records);
        this.duration = DurationFilter.checkDuration(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        DurationFilter other;
        long s;
        long p;
        long c;
        long d;
        long r;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            r = this.records;
            d = this.duration;
            c = this.count;
            p = this.peak;
            s = this.start;
        }
        DurationFilter durationFilter2 = other = (DurationFilter)obj;
        synchronized (durationFilter2) {
            if (r != other.records || d != other.duration || c != other.count || p != other.peak || s != other.start) {
                return false;
            }
        }
        return true;
    }

    public boolean isIdle() {
        return this.test(0L, System.currentTimeMillis());
    }

    public synchronized int hashCode() {
        int hash = 3;
        hash = 89 * hash + Long.hashCode(this.records);
        hash = 89 * hash + Long.hashCode(this.duration);
        return hash;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.accept(record.getMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggable() {
        long r;
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            r = this.records;
        }
        return this.test(r, System.currentTimeMillis());
    }

    public synchronized long getRecords() {
        LogManagerProperties.checkLogManagerAccess();
        return this.records;
    }

    public synchronized void setRecords(long records) {
        LogManagerProperties.checkLogManagerAccess();
        this.records = DurationFilter.checkRecords(records);
    }

    public synchronized void setDurationMillis(long duration) {
        LogManagerProperties.checkLogManagerAccess();
        this.duration = DurationFilter.checkDuration(duration);
    }

    public synchronized long getDurationMillis() {
        LogManagerProperties.checkLogManagerAccess();
        return this.duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean loggable;
        boolean idle;
        long d;
        long r;
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            r = this.records;
            d = this.duration;
            long millis = System.currentTimeMillis();
            idle = this.test(0L, millis);
            loggable = this.test(r, millis);
        }
        return this.getClass().getName() + "{records=" + r + ", duration=" + d + ", idle=" + idle + ", loggable=" + loggable + "}";
    }

    protected DurationFilter clone() throws CloneNotSupportedException {
        DurationFilter clone = (DurationFilter)super.clone();
        clone.count = 0L;
        clone.peak = 0L;
        clone.start = 0L;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test(long limit, long millis) {
        long s;
        long c;
        long d;
        assert (limit >= 0L) : limit;
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            d = this.duration;
            c = this.count;
            s = this.start;
        }
        return c > 0L ? millis - s >= d || c < limit : millis - s >= 0L || c == 0L;
    }

    private synchronized boolean accept(long millis) {
        boolean allow;
        if (this.count > 0L) {
            if (millis - this.peak > 0L) {
                this.peak = millis;
            }
            if (this.records - this.count > 0L) {
                ++this.count;
                allow = true;
            } else if (this.peak - this.start >= this.duration) {
                this.count = 1L;
                this.start = this.peak;
                allow = true;
            } else {
                this.count = -1L;
                this.start = this.peak + this.duration;
                allow = false;
            }
        } else if (millis - this.start >= 0L || this.count == 0L) {
            this.count = 1L;
            this.start = millis;
            this.peak = millis;
            allow = true;
        } else {
            allow = false;
        }
        return allow;
    }

    private long initLong(String suffix) {
        long result = 0L;
        String p = this.getClass().getName();
        String value = LogManagerProperties.fromLogManager(p.concat(suffix));
        if (value != null && value.length() != 0) {
            if (this.isTimeEntry(suffix, value = value.trim())) {
                try {
                    result = LogManagerProperties.parseDurationToMillis(value);
                }
                catch (Exception | LinkageError throwable) {
                    // empty catch block
                }
            }
            if (result == 0L) {
                try {
                    result = 1L;
                    for (String s : DurationFilter.tokenizeLongs(value)) {
                        if (s.endsWith("L") || s.endsWith("l")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        result = Math.multiplyExact(result, Long.parseLong(s));
                    }
                }
                catch (RuntimeException ignore) {
                    result = Long.MIN_VALUE;
                }
            }
        } else {
            result = Long.MIN_VALUE;
        }
        return result;
    }

    private boolean isTimeEntry(String suffix, String value) {
        return (value.charAt(0) == 'P' || value.charAt(0) == 'p') && suffix.equals(".duration");
    }

    private static String[] tokenizeLongs(String value) {
        String[] e;
        int i = value.indexOf(42);
        if (i > -1 && (e = value.split("\\s*\\*\\s*")).length != 0) {
            if (i == 0 || value.charAt(value.length() - 1) == '*') {
                throw new NumberFormatException(value);
            }
            if (e.length == 1) {
                throw new NumberFormatException(e[0]);
            }
        } else {
            e = new String[]{value};
        }
        return e;
    }

    private static long checkRecords(long records) {
        return records > 0L ? records : 1000L;
    }

    private static long checkDuration(long duration) {
        return duration > 0L ? duration : 900000L;
    }
}

