/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.script;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.script.DummyParameterAttribute;
import org.eclipse.birt.report.data.adapter.api.script.ReportContextObject;
import org.eclipse.birt.report.data.adapter.api.script.ReportParameters;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataAdapterTopLevelScope
extends ImporterTopLevel {
    private static final long serialVersionUID = 4230948829384L;
    private static final String PROP_PARAMS = "params";
    private static final String PROP_REPORTCONTEXT = "reportContext";
    private ModuleHandle designModule;
    private Scriptable paramsProp;
    private Object reportContextProp;

    public DataAdapterTopLevelScope(Context cx, ModuleHandle module) {
        super(cx);
        new CoreJavaScriptInitializer().initialize(cx, (Scriptable)this);
        this.designModule = module;
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return true;
        }
        return PROP_REPORTCONTEXT.equals(name);
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return this.getParamsScriptable();
        }
        if (PROP_REPORTCONTEXT.equals(name)) {
            return this.getReportContext();
        }
        return NOT_FOUND;
    }

    private Object getReportContext() {
        if (this.reportContextProp != null) {
            return this.reportContextProp;
        }
        assert (this.designModule != null);
        this.reportContextProp = new ReportContextObject(this.designModule);
        return this.reportContextProp;
    }

    private Scriptable getParamsScriptable() {
        if (this.paramsProp != null) {
            return this.paramsProp;
        }
        assert (this.designModule != null);
        HashMap<String, DummyParameterAttribute> parameters = new HashMap<String, DummyParameterAttribute>();
        List paramsList = this.designModule.getAllParameters();
        int i = 0;
        while (i < paramsList.size()) {
            Object parameterObject = paramsList.get(i);
            if (parameterObject instanceof ScalarParameterHandle) {
                ScalarParameterHandle parameterHandle = (ScalarParameterHandle)parameterObject;
                Object value = DataAdapterUtil.getParamValueFromConfigFile(parameterHandle);
                if (value == null) {
                    value = this.getParamDefaultValue(parameterHandle);
                }
                parameters.put(((ScalarParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(value, ""));
            }
            ++i;
        }
        this.paramsProp = new ReportParameters(parameters, (Scriptable)this);
        return this.paramsProp;
    }

    private Object getParamDefaultValue(Object params) {
        if (!(params instanceof ScalarParameterHandle)) {
            return null;
        }
        ScalarParameterHandle sp = (ScalarParameterHandle)params;
        String defaultValue = sp.getDefaultValue();
        String type = sp.getDataType();
        if (defaultValue == null) {
            if (sp.allowNull()) {
                return null;
            }
            if ("string".equals(type)) {
                return "";
            }
            if ("float".equals(type)) {
                return new Double(0.0);
            }
            if ("decimal".equals(type)) {
                return new BigDecimal(0.0);
            }
            if ("dateTime".equals(type)) {
                return new Date(0L);
            }
            if ("date".equals(type)) {
                return new java.sql.Date(0L);
            }
            if ("time".equals(type)) {
                return new Time(0L);
            }
            if ("boolean".equals(type)) {
                return Boolean.FALSE;
            }
            if ("integer".equals(type)) {
                return new Integer(0);
            }
            assert (false);
            return null;
        }
        try {
            return DataTypeUtil.convert((Object)defaultValue, (int)DataAdapterUtil.modelDataTypeToCoreDataType(type));
        }
        catch (BirtException birtException) {
            return null;
        }
    }

    private static boolean isToBeConverted(String type) {
        return type.equals("string") || type.equals("dateTime") || type.equals("time") || type.equals("date");
    }
}

