/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class CompatibilityUtil {
    public static void updateResultSetinCachedMetaData(DataSetHandle setHandle, List resultColumns) throws SemanticException {
        if (setHandle == null) {
            return;
        }
        if (resultColumns == null || resultColumns.isEmpty()) {
            return;
        }
        CachedMetaDataHandle originalMetaData = setHandle.getCachedMetaDataHandle();
        CachedMetaData metaData = StructureFactory.createCachedMetaData();
        metaData.setProperty("resultSet", (Object)resultColumns);
        PropertyValueValidationUtil.validateProperty(setHandle, "cachedMetaData", metaData);
        if (originalMetaData == null) {
            setHandle.getElement().setProperty("cachedMetaData", (Object)metaData);
        } else {
            metaData.setProperty("resultSet", null);
            metaData = null;
            metaData = (CachedMetaData)originalMetaData.getStructure();
            metaData.setProperty("resultSet", (Object)resultColumns);
        }
    }

    public static void addStructures(PropertyHandle propHandle, List structures) throws SemanticException {
        if (structures == null || structures.isEmpty()) {
            return;
        }
        if (propHandle == null) {
            return;
        }
        DesignElementHandle element = propHandle.getElementHandle();
        IPropertyDefn propDefn = propHandle.getDefn();
        PropertyValueValidationUtil.validateProperty(element, propDefn.getName(), structures);
        ArrayList oldList = element.getListProperty(propDefn.getName());
        List newList = null;
        if (!propHandle.isLocal()) {
            newList = oldList != null ? (List)ModelUtil.copyValue(propDefn, oldList) : new ArrayList();
            element.getElement().setProperty((ElementPropertyDefn)propDefn, newList);
        } else {
            newList = oldList;
        }
        newList.addAll(structures);
    }

    public static void addResultSetColumn(DataSetHandle dataSetHandle, List columns) throws SemanticException {
        if (dataSetHandle == null) {
            return;
        }
        CompatibilityUtil.addStructures(dataSetHandle.getPropertyHandle("resultSet"), columns);
    }
}

