/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.extension.IChoiceDefinition;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;

public class ExtensionStructPropertyDefn
extends StructPropertyDefn {
    private IPropertyDefinition extMember = null;

    public ExtensionStructPropertyDefn(IPropertyDefinition extMemberDefn) {
        this.extMember = extMemberDefn;
        assert (this.extMember != null);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.type = dd.getPropertyType(extMemberDefn.getType());
        this.name = this.extMember.getName();
        this.defaultValue = this.extMember.getDefaultValue();
    }

    public IChoiceSet getChoices() {
        List choices = this.extMember.getChoices();
        if (choices == null) {
            return null;
        }
        if (choices.size() == 0) {
            return null;
        }
        IChoice[] choiceArray = new Choice[choices.size()];
        Iterator iter = choices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IChoiceDefinition choice = (IChoiceDefinition)iter.next();
            ExtensionChoice extChoice = new ExtensionChoice(choice, null);
            choiceArray[i] = extChoice;
            ++i;
        }
        assert (i == choices.size());
        ChoiceSet set = new ChoiceSet();
        set.setChoices(choiceArray);
        this.details = set;
        return set;
    }

    public Object getDefault() {
        return this.extMember.getDefaultValue();
    }

    public String getDisplayName() {
        return null;
    }

    public IChoiceSet getAllowedChoices() {
        return this.getChoices();
    }

    public String getDisplayNameID() {
        return null;
    }

    public String getName() {
        return this.extMember.getName();
    }

    public IStructureDefn getStructDefn() {
        if (this.details instanceof StructureDefn) {
            return (StructureDefn)this.details;
        }
        List members = this.extMember.getMembers();
        if (members == null) {
            return null;
        }
        StructureDefn struct = new StructureDefn();
        for (IPropertyDefinition prop : members) {
            try {
                struct.addProperty(new ExtensionStructPropertyDefn(prop));
            }
            catch (MetaDataException metaDataException) {
                assert (false);
                return null;
            }
        }
        this.details = struct;
        return struct;
    }

    public IElementDefn getTargetElementType() {
        return null;
    }

    public PropertyType getType() {
        int typeCode = this.extMember.getType();
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        return dd.getPropertyType(typeCode);
    }

    public int getTypeCode() {
        PropertyType type = this.getType();
        assert (type != null);
        return type.getTypeCode();
    }

    public boolean isIntrinsic() {
        return false;
    }

    public boolean isList() {
        return this.extMember.isList();
    }

    void setAllowedChoices(ChoiceSet allowedChoices) {
        assert (false);
    }

    protected void setDefault(Object value) {
        assert (false);
    }

    public void setDetails(Object obj) {
        assert (false);
    }

    public void setDisplayNameID(String id) {
        assert (false);
    }

    void setIntrinsic(boolean flag) {
        assert (false);
    }

    protected void setIsList(boolean isList) {
        assert (false);
    }

    public void setName(String theName) {
        assert (false);
    }

    public void setType(PropertyType typeDefn) {
        assert (false);
    }

    public boolean isExtended() {
        return true;
    }

    public int getValueType() {
        return 3;
    }
}

