/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.eclipse.birt.build.PluginWrapper;
import org.eclipse.birt.build.StringUtil;

public class BuildUtil {
    public static String getPluginVersion(File pluginDir) {
        String version = null;
        File pluginXML = new File(pluginDir, "plugin.xml");
        if (pluginXML.exists() && !StringUtil.isBlank(version = new PluginWrapper(pluginXML).getPluginVersion())) {
            return version;
        }
        File manifest = new File(new File(pluginDir, "META-INF"), "MANIFEST.MF");
        if (manifest.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(manifest));
                return props.getProperty("Bundle-Version");
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return null;
    }

    public static boolean checkAboutFile(File jarname) {
        try {
            JarFile a = new JarFile(jarname);
            return a.getEntry("about.html") != null;
        }
        catch (IOException e) {
            System.out.println(String.valueOf(e.getMessage()) + e.getStackTrace());
            System.out.println("JAR doesn't exist");
            return false;
        }
    }

    public static File[] getJarList(String dir) {
        File file = new File(dir);
        File[] flist = file.listFiles(new JarFileFilter());
        return flist;
    }

    static class JarFileFilter
    implements FileFilter {
        JarFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }

        public static void main(String[] args) {
            String checkdir = "E:/test/2_6_0/temp/birt-updatesite-2_6_0-20100601/plugins";
            File[] list = BuildUtil.getJarList(checkdir);
            int i = 0;
            while (i < list.length) {
                System.out.println("Checking " + list[i].getName());
                if (!BuildUtil.checkAboutFile(list[i])) {
                    System.out.println("File: " + list[i].getName() + "............................missing about.html");
                }
                ++i;
            }
        }
    }
}

