/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.birt.build.BuildUtil;
import org.eclipse.birt.build.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureUpdater
extends Task {
    File featureDir = null;
    File pluginDir = null;
    String timeStamp = null;
    String packageId = null;
    File featureXML = null;
    static final String VERSION_PLACEHOLDER = "0.0.0";
    List pluginsInFeature = new ArrayList();
    Map versionMap = new HashMap();

    public void setProjectPath(File featureDir) {
        this.featureDir = featureDir;
        this.featureXML = new File(featureDir, "feature.xml");
    }

    public void setPackageId(String PackageId) {
        this.packageId = PackageId;
    }

    public void setPluginDir(File pluginDir) {
        this.pluginDir = pluginDir;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void execute() throws BuildException {
        if (this.featureDir == null) {
            throw new BuildException("Specify the manatory \"dir\" attribute.");
        }
        if (this.pluginDir == null) {
            throw new BuildException("Specify the manatory \"pluginDir\" attribute.");
        }
        if (!this.featureXML.exists()) {
            throw new BuildException("Missing \"feature.xml\" under " + this.featureDir.getAbsolutePath());
        }
        this.parseFeature(this.featureXML);
        this.buildVersions();
        this.updateFeature();
        this.sanityCheck();
    }

    void parseFeature(File feature) {
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(feature);
        }
        catch (Exception e) {
            this.handleErrorOutput("Error occur when parsing feature file: " + feature);
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
        this.handleOutput("Start parsing feature.xml[" + feature.getAbsolutePath() + "]....... ");
        ArrayList<Node> matchingNodes = new ArrayList<Node>();
        NodeList features = doc.getElementsByTagName("feature");
        if (features == null || features.getLength() != 1) {
            this.handleOutput("Wrong feature.xml files, not feature tag or more than one feature tag includes.");
        }
        if (features == null) {
            return;
        }
        Node featureNode = features.item(0);
        NodeList pluginNodes = featureNode.getOwnerDocument().getElementsByTagName("plugin");
        NodeList includesNodes = featureNode.getOwnerDocument().getElementsByTagName("includes");
        int j = 0;
        while (j < pluginNodes.getLength()) {
            matchingNodes.add(pluginNodes.item(j));
            ++j;
        }
        j = 0;
        while (j < includesNodes.getLength()) {
            matchingNodes.add(includesNodes.item(j));
            ++j;
        }
        j = 0;
        int pluginCounter = 0;
        int includesCounter = 0;
        while (j < matchingNodes.size()) {
            Node node = (Node)matchingNodes.get(j);
            String tag = node.getNodeName();
            int counter = "plugin".equals(StringUtil.trimString(tag)) ? ++pluginCounter : ++includesCounter;
            String id = node.getAttributes().getNamedItem("id").getNodeValue();
            String version = node.getAttributes().getNamedItem("version").getNodeValue();
            this.handleOutput("Mathcing <" + tag + "[" + counter + "]: id=\"" + id + "\" " + "version=\"" + version + "\"");
            if (StringUtil.isBlank(version)) {
                this.handleErrorOutput("Wrong feature.xml. Plugin :[" + id + "] doesn't specify version value");
                this.handleErrorOutput("This plugin node is ignored....");
                this.pluginsInFeature.add(null);
            } else if (!VERSION_PLACEHOLDER.equals(version)) {
                this.handleErrorOutput("feature.xml may be incorrect. Plugin node [" + id + "] should have \"" + VERSION_PLACEHOLDER + "\" for its version number.");
                this.handleErrorOutput("This plugin node is ignored....");
                this.pluginsInFeature.add(null);
            } else {
                this.pluginsInFeature.add(id);
            }
            ++j;
        }
    }

    private void buildVersions() {
        File[] pluginDirs = this.pluginDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        HashMap<String, File> pluginIdToFile = new HashMap<String, File>();
        int i = 0;
        while (i < pluginDirs.length) {
            pluginIdToFile.put(pluginDirs[i].getName(), pluginDirs[i]);
            ++i;
        }
        for (String id : this.pluginsInFeature) {
            File pluginDir = (File)pluginIdToFile.get(id);
            if (pluginDir == null) {
                this.handleErrorOutput("Plugin [" + id + "] in the feature.xml doesn't exist in folder \"" + this.pluginDir + "\"");
                continue;
            }
            String newVersion = BuildUtil.getPluginVersion(pluginDir);
            if (StringUtil.isBlank(newVersion)) {
                throw new BuildException("We can not identify the plugin version for plugin \"" + pluginDir.getAbsolutePath() + "\"");
            }
            this.versionMap.put(id, newVersion);
        }
    }

    void updateFeature() {
        StringBuffer sb;
        block33: {
            block31: {
                sb = new StringBuffer();
                BufferedReader reader = null;
                String line = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(this.featureXML));
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                            sb.append("\n");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Matcher qualifierMatcher = Pattern.compile(".qualifier").matcher(sb);
            sb = new StringBuffer();
            while (qualifierMatcher.find()) {
                qualifierMatcher.appendReplacement(sb, this.timeStamp);
            }
            qualifierMatcher.appendTail(sb);
            Matcher pluginMatcher = Pattern.compile("<includes[\\s]|<plugin[\\s]").matcher(sb);
            Matcher idMatcher = Pattern.compile(".*id[\\s]*=[\\s]*\".+\".*").matcher(sb);
            Matcher versionMatcher = Pattern.compile("version[\\s]*=[\\s]*\"0.0.0\"").matcher(sb);
            Matcher xmlEndingMatcher = Pattern.compile("/>").matcher(sb);
            while (pluginMatcher.find()) {
                String value = pluginMatcher.group();
                this.handleOutput("Find another matching tag: [" + pluginMatcher.group() + "]");
                int include_end = pluginMatcher.end();
                int include_start = pluginMatcher.start();
                boolean endXML = xmlEndingMatcher.find(include_end);
                assert (endXML);
                int endXML_pos = xmlEndingMatcher.start();
                if (!idMatcher.find(include_start)) {
                    this.handleErrorOutput("No match for id=\"XX.XX.XX\"... continue with next match");
                    continue;
                }
                int id_start = idMatcher.start();
                if (id_start > endXML_pos) {
                    this.handleErrorOutput("Wrong id possition, this plugin tag doesn't contain a id attribute...");
                    continue;
                }
                String idStr = idMatcher.group().trim();
                String id = idStr.substring(idStr.indexOf(34) + 1, idStr.lastIndexOf(34));
                String version = (String)this.versionMap.get(id);
                this.handleOutput("The new version for : [" + id + "] is version:[" + version + "]");
                if (!versionMatcher.find(include_end)) {
                    this.handleOutput("Can not find a matching token version=\"0.0.0\",  [" + id + "]");
                    continue;
                }
                int version_start = versionMatcher.start();
                int version_end = versionMatcher.end();
                if (version_start > endXML_pos) {
                    this.handleErrorOutput("Wrong version possition, this plugin tag doesn't contain a version attribute...");
                    continue;
                }
                String tmpPrefix = this.packageId;
                String tmpTimeStamp = tmpPrefix.concat(this.timeStamp);
                if (value.indexOf("<includes") != -1) {
                    sb.replace(version_start, version_end, "version=\"" + tmpTimeStamp + "\"");
                } else {
                    sb.replace(version_start, version_end, "version=\"" + version + "\"");
                }
                this.handleOutput("Update [" + id + "]  with: " + "version=\"" + version + "\"");
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.featureXML));
                    writer.write(sb.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        writer.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(sb);
    }

    private void sanityCheck() {
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(this.featureXML);
        }
        catch (Exception e) {
            this.handleErrorOutput("[Sanity]Error occur when parsing feature file: " + this.featureXML);
        }
        ArrayList<Node> matchingNodes = new ArrayList<Node>();
        ArrayList<Node> matchingNodesIncludes = new ArrayList<Node>();
        NodeList features = doc.getElementsByTagName("feature");
        if (features == null || features.getLength() != 1) {
            this.handleErrorOutput("[Sanity]failed to to incorrect feature file, missing feature tag.");
            return;
        }
        if (features == null) {
            return;
        }
        Node featureNode = features.item(0);
        NodeList pluginsNodes = featureNode.getOwnerDocument().getElementsByTagName("plugin");
        NodeList includesNodes = featureNode.getOwnerDocument().getElementsByTagName("includes");
        int j = 0;
        while (j < pluginsNodes.getLength()) {
            matchingNodes.add(pluginsNodes.item(j));
            ++j;
        }
        j = 0;
        while (j < includesNodes.getLength()) {
            matchingNodesIncludes.add(includesNodes.item(j));
            ++j;
        }
        boolean success = true;
        String DOTS = "..................";
        ArrayList<String> errorids = new ArrayList<String>();
        this.handleOutput("\nSanity check report for \"" + this.featureXML.getAbsolutePath() + "\"");
        int j2 = 0;
        while (j2 < matchingNodes.size()) {
            String newVersion;
            Node pluginNode = (Node)matchingNodes.get(j2);
            String id = pluginNode.getAttributes().getNamedItem("id").getNodeValue();
            String version = pluginNode.getAttributes().getNamedItem("version").getNodeValue();
            if (StringUtil.isEqual(version, newVersion = (String)this.versionMap.get(id))) {
                this.handleOutput("Check id[" + id + "]" + ".................." + " success, updated to [" + version + "]");
            } else {
                this.handleErrorOutput("Check id[" + id + "]" + ".................." + "fail, old version is: [" + version + "],  plugin.version is: [" + newVersion + "]");
                errorids.add(id);
                success = false;
            }
            ++j2;
        }
        if (success) {
            this.handleOutput("Sanity check for plugins........ all success.");
        } else {
            this.handleErrorOutput("Sanity check for plugins ........ has failure in: " + errorids);
        }
        j2 = 0;
        while (j2 < matchingNodesIncludes.size()) {
            Node pluginNode2 = (Node)matchingNodesIncludes.get(j2);
            String version2 = pluginNode2.getAttributes().getNamedItem("version").getNodeValue();
            String id2 = pluginNode2.getAttributes().getNamedItem("id").getNodeValue();
            String tmpPrefix2 = "2.1.0";
            String newVersion2 = tmpPrefix2.concat(this.timeStamp);
            if (StringUtil.isEqual(version2, newVersion2)) {
                this.handleOutput("Check id[" + id2 + "]" + ".................." + " success, updated to [" + version2 + "]");
                success = true;
            } else {
                this.handleErrorOutput("Check id[" + id2 + "]" + ".................." + "fail, old version is: [" + version2 + "],  plugin.version is: [" + newVersion2 + "]");
                errorids.add(id2);
                success = false;
            }
            ++j2;
        }
        if (success) {
            this.handleOutput("Sanity check for includes features........ all success.");
        } else {
            this.handleErrorOutput("Sanity check for included features ........ has failure in: " + errorids);
        }
        this.handleOutput("End of sanity check [" + this.featureXML.getAbsolutePath() + "]\n");
    }
}

