/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.eclipse.birt.build.DynamicProperty;
import org.eclipse.birt.build.ProjectInfo;
import org.eclipse.birt.build.ProjectList;

public class ForEach
extends Task
implements TaskContainer {
    public final String TASK_STATUS_PASS = "pass";
    public final String TASK_STATUS_FAIL = "fail";
    public final String TASK_STATUS_FAIL_ON_DEPENDENCY = "failOnDependency";
    protected Vector nestedTasks = new Vector();
    protected String refID;
    protected String failurePropertyName = "task.issuccess";
    protected ArrayList dynamicProperties = new ArrayList();
    protected boolean failOnError = true;
    protected String loggerPath = null;

    public void setIteratorId(String id) {
        this.refID = id;
    }

    public void setFailureProperty(String propertyName) {
        this.failurePropertyName = propertyName;
    }

    public void setLoggerPath(String loggerPath) {
        this.loggerPath = loggerPath;
    }

    public void addDynamicProperty(DynamicProperty property) {
        this.dynamicProperties.add(property);
    }

    public void setFailOnError(boolean f) {
        this.failOnError = f;
    }

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void execute() throws BuildException {
        Object o = this.getProject().getReference(this.refID);
        if (!(o instanceof ProjectList)) {
            this.log("ForEach only support one ProjectList reference!", 0);
            throw new BuildException("ForEach only support one ProjectList reference!");
        }
        ProjectList list = (ProjectList)o;
        int i = 0;
        while (i < list.getCount()) {
            ProjectInfo projectInfo = list.getProject(i);
            int j = 0;
            while (j < this.dynamicProperties.size()) {
                DynamicProperty property = (DynamicProperty)((Object)this.dynamicProperties.get(j));
                this.getDynamicValue(projectInfo, property);
                ++j;
            }
            DefaultLogger logger = null;
            if (this.loggerPath != null) {
                File loggerPathDir = new File(this.loggerPath);
                if (!loggerPathDir.exists()) {
                    loggerPathDir.mkdir();
                }
                if (!loggerPathDir.isDirectory()) {
                    throw new BuildException("loggerPath attribute should reference to a directory.");
                }
                logger = new DefaultLogger();
                PrintStream str = null;
                try {
                    String fileName = String.valueOf(projectInfo.getValue("projectName")) + "_log.txt";
                    str = new PrintStream(new FileOutputStream(new File(loggerPathDir, fileName), true), true);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                logger.setMessageOutputLevel(2);
                logger.setErrorPrintStream(str);
                logger.setOutputPrintStream(str);
                this.getProject().addBuildListener((BuildListener)logger);
            }
            Enumeration e = this.nestedTasks.elements();
            while (e.hasMoreElements()) {
                Task nestedTask = (Task)e.nextElement();
                try {
                    nestedTask.perform();
                    this.getProject().setProperty(this.failurePropertyName, "pass");
                }
                catch (BuildException ex) {
                    this.log("Execution error on task: [" + nestedTask.getTaskName() + "] message: " + ex.toString(), 1);
                    if ("Ant".equalsIgnoreCase(nestedTask.getTaskName())) {
                        if (this.isThisProjectError(ex)) {
                            this.getProject().setProperty(this.failurePropertyName, "fail");
                            this.log("Project failed on itself: ", 0);
                        } else {
                            this.getProject().setProperty(this.failurePropertyName, "failOnDependency");
                            this.log("Project failed on dependencies:", 1);
                        }
                    }
                    if (this.failOnError) {
                        throw ex;
                    }
                    this.log("Continue execution.", 2);
                }
            }
            if (logger != null) {
                this.getProject().removeBuildListener(logger);
            }
            ++i;
        }
    }

    private String getDynamicValue(ProjectInfo info, DynamicProperty property) {
        String result = "";
        String value = property.getValue();
        String[] tokens = value.split(",");
        int i = 0;
        while (i < tokens.length) {
            result = String.valueOf(result) + this.getRuntimeValue(info, tokens[i].trim());
            ++i;
        }
        this.getProject().setProperty(property.getName(), result);
        return result;
    }

    private String getRuntimeValue(ProjectInfo info, String key) {
        String CURRENT_KEY = "current";
        if (key.startsWith("current")) {
            return info.getValue(key.substring("current".length() + 1));
        }
        if (key.startsWith("'") && key.endsWith("'")) {
            return key.substring(1, key.length() - 1);
        }
        return this.getProject().getProperty(key);
    }

    private boolean isThisProjectError(BuildException ex) {
        String extScriptFileName;
        Location extScriptLocation;
        BuildException e = (BuildException)ex.getCause();
        if (e == null) {
            return true;
        }
        Location baseScriptLocation = e.getLocation();
        if (baseScriptLocation == null) {
            return true;
        }
        String baseScriptFileName = baseScriptLocation.getFileName();
        if (baseScriptFileName == null) {
            return true;
        }
        String baseScriptPath = baseScriptFileName.substring(0, baseScriptFileName.lastIndexOf(File.separator));
        assert (baseScriptPath != null);
        Throwable current = e;
        BuildException old = current;
        while (current != null) {
            old = current;
            current = current.getCause();
        }
        if (old instanceof BuildException && (extScriptLocation = old.getLocation()) != null && (extScriptFileName = extScriptLocation.getFileName()) != null && !extScriptFileName.startsWith(baseScriptPath)) {
            this.log("Task failed on its dependency : " + extScriptLocation.getFileName() + " Original script path " + baseScriptPath, 0);
            return false;
        }
        return true;
    }
}

