/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Replace;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.birt.build.StringUtil;

public class VersionUpdater
extends Task {
    private File projectPath = null;
    private String checkFlag = null;
    private File cvsLogPath = null;
    private File cvsControlPath = null;
    private File logPath = null;
    private String plugId = null;
    private int daysInPast = 1;
    private String suffix = null;
    private String oldVersion = null;
    boolean pluginTagStart = false;
    String pluginId = null;
    String pluginVersion = null;
    private static String ENTRYNAME = "entry";

    public void setProjectPath(File path) {
        this.projectPath = path;
    }

    public void setCvsLogPath(File cvsLogPath) {
        this.cvsLogPath = cvsLogPath;
    }

    public void setCvsControlPath(File cvsControlPath) {
        this.cvsControlPath = cvsControlPath;
    }

    public void execute() {
        if (this.projectPath == null) {
            throw new BuildException("Please specify the correct projectPath.");
        }
        File manifestFile = new File(new File(this.projectPath, "META-INF"), "MANIFEST.MF");
        if (manifestFile.exists()) {
            this.updateManifest(manifestFile);
        }
    }

    private void updateManifest(File manifest) {
        Replace replace = new Replace();
        replace.setProject(this.getProject());
        replace.setFile(manifest);
        replace.setToken(".qualifier");
        if (this.checkFlag.equals("N")) {
            replace.setValue(this.suffix);
        } else {
            this.getLastVersion(this.cvsControlPath);
            if (this.ifUpdate(this.cvsLogPath)) {
                replace.setValue(this.suffix);
                this.handleErrorOutput("Update plug-in [" + this.plugId + "] to new version :" + this.suffix);
                this.genVersionLog(this.logPath, this.plugId, this.suffix, 1);
            } else {
                replace.setValue(this.oldVersion);
                this.handleErrorOutput("Update plug-in [" + this.plugId + "] to old version :" + this.oldVersion);
                this.genVersionLog(this.logPath, this.plugId, this.oldVersion, this.daysInPast + 1);
            }
        }
        replace.execute();
        String pluginId = null;
        String pluginVersion = null;
        Manifest mani = new Manifest();
        if (manifest.exists()) {
            InputStream is = null;
            try {
                try {
                    is = new FileInputStream(manifest);
                    mani.read(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException((Throwable)e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            pluginId = StringUtil.trimString(mani.getMainAttributes().getValue("Bundle-SymbolicName"));
            if (pluginId != null && pluginId.indexOf(59) != -1) {
                int index = pluginId.indexOf(59);
                pluginId = StringUtil.trimString(pluginId.substring(0, index));
            }
            pluginVersion = StringUtil.trimString(mani.getMainAttributes().getValue("Bundle-Version"));
        }
        if (pluginId == null) {
            this.handleErrorOutput("Can not find Bundle-SymbolicName for manifest under " + this.projectPath);
        } else if (pluginVersion == null) {
            this.handleErrorOutput("Can not identify Bundle-Version for manifest under " + this.projectPath);
        }
    }

    public void setCheckFlag(String checkFlag) {
        this.checkFlag = checkFlag;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDaysInPast(int daysInPast) {
        this.daysInPast = daysInPast;
    }

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public void setLogPath(File logPath) {
        this.logPath = logPath;
    }

    public void setPlugId(String plugId) {
        this.plugId = plugId;
    }

    private boolean ifUpdate(File xmlf) {
        String name = "";
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(this.cvsLogPath);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            name = element.getName();
            if (!name.equalsIgnoreCase(ENTRYNAME)) continue;
            return true;
        }
        return false;
    }

    private void genVersionLog(File folderPath, String plug_id, String lastDate, int dayInpast) {
        String parentPath = folderPath.getAbsolutePath();
        String fileName = String.valueOf(plug_id) + "_DayInPast" + ".xml";
        String fullName = String.valueOf(parentPath) + "/" + fileName;
        File dest = new File(fullName);
        System.out.println("dest file full path:\t" + fullName);
        try {
            DocumentFactory factory = new DocumentFactory();
            DOMElement rootElement = new DOMElement("plugin");
            rootElement.setAttribute("id", plug_id);
            DOMElement dateElement = new DOMElement("LastDate");
            dateElement.setText(lastDate);
            rootElement.add((Element)dateElement);
            DOMElement dayElement = new DOMElement("DayInPast");
            dayElement.setText(Integer.toString(dayInpast));
            rootElement.add((Element)dayElement);
            Document doc = factory.createDocument((Element)rootElement);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(dest), format);
            writer.write(doc);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getLastVersion(File controlpath) {
        System.out.println("old version file path: " + controlpath.getAbsolutePath());
        String dayTag = "DayInPast";
        String versionTag = "LastDate";
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(this.cvsControlPath);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String name = element.getName();
            if (name.equalsIgnoreCase(versionTag)) {
                this.oldVersion = element.getText();
                continue;
            }
            if (!name.equalsIgnoreCase(dayTag)) continue;
            this.daysInPast = Integer.parseInt(element.getText().trim());
        }
    }
}

