/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.ant;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.tools.ant.Task;

public class TaskLogger
extends Logger {
    Task task;

    protected TaskLogger(Task task) {
        super("", null);
        this.task = task;
    }

    protected int getMessageLevel(LogRecord record) {
        Level level = record.getLevel();
        if (level.equals(Level.SEVERE)) {
            return 0;
        }
        if (level.equals(Level.WARNING)) {
            return 1;
        }
        if (level.equals(Level.INFO)) {
            return 2;
        }
        return 3;
    }

    protected String getMessage(LogRecord record) {
        String format = record.getMessage();
        Object[] params = record.getParameters();
        if (params == null || params.length == 0) {
            return format;
        }
        try {
            return MessageFormat.format(format, params);
        }
        catch (Exception ex) {
            return format;
        }
    }

    @Override
    public void log(LogRecord record) {
        int level = this.getMessageLevel(record);
        String message = this.getMessage(record);
        Throwable thrown = record.getThrown();
        this.task.log(message, thrown, level);
    }
}

